/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory.data;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class BooleanTypeAdapter
extends TypeAdapter<Boolean> {
    public Boolean read(JsonReader in) throws IOException {
        JsonToken jsonToken = in.peek();
        switch (jsonToken) {
            case BOOLEAN: {
                return in.nextBoolean();
            }
            case STRING: {
                String result = in.nextString();
                if (String.valueOf(true).equalsIgnoreCase(result)) {
                    return true;
                }
                if (String.valueOf(false).equalsIgnoreCase(result)) {
                    return false;
                }
                throw new IllegalArgumentException("Data parsing failed, unable to convert " + result + " to boolean type");
            }
            case NUMBER: {
                return in.nextInt() != 0;
            }
            case NULL: {
                in.nextNull();
                return null;
            }
        }
        in.skipValue();
        throw new IllegalArgumentException("The current parser is of type Boolean, but the data is of type " + jsonToken);
    }

    public void write(JsonWriter out, Boolean value) throws IOException {
        out.value(value);
    }
}

