/*
 * Decompiled with CFR 0.152.
 */
package org.yi.acru.bukkit.Lockette;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.yi.acru.bukkit.BlockUtil;
import org.yi.acru.bukkit.Lockette.Lockette;
import org.yi.acru.bukkit.PluginCore;

public class LocketteBlockListener
implements Listener {
    private static Lockette plugin;

    public LocketteBlockListener(Lockette instance) {
        plugin = instance;
    }

    protected void registerEvents() {
        PluginManager pm = plugin.getServer().getPluginManager();
        pm.registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        int type = block.getTypeId();
        if (event.isCancelled() && !BlockUtil.isInList(type, BlockUtil.materialListJustDoors)) {
            return;
        }
        if (type == Material.WALL_SIGN.getId()) {
            Sign sign;
            String text;
            if (block.getData() == 0) {
                block.setData((byte)5);
            }
            if ((text = ChatColor.stripColor((String)(sign = (Sign)block.getState()).getLine(0))).equalsIgnoreCase("[Private]") || text.equalsIgnoreCase(Lockette.altPrivate)) {
                int length = player.getName().length();
                if (Lockette.isOwner(sign, (OfflinePlayer)player)) {
                    Lockette.log.info("[" + plugin.getDescription().getName() + "] " + player.getName() + " has released a container.");
                    Lockette.removeUUIDMetadata(sign);
                    plugin.localizedMessage(player, null, "msg-owner-release");
                    return;
                }
                if (Lockette.adminBreak) {
                    boolean snoop = false;
                    if (plugin.hasPermission(block.getWorld(), player, "lockette.admin.break")) {
                        snoop = true;
                    }
                    if (snoop) {
                        Lockette.log.info("[" + plugin.getDescription().getName() + "] (Admin) " + player.getName() + " has broken open a container owned by " + sign.getLine(1) + "!");
                        Lockette.removeUUIDMetadata(sign);
                        plugin.localizedMessage(player, Lockette.broadcastBreakTarget, "msg-admin-release", sign.getLine(1));
                        return;
                    }
                }
                event.setCancelled(true);
                sign.update();
                plugin.localizedMessage(player, null, "msg-user-release-owned", sign.getLine(1));
            } else if (text.equalsIgnoreCase("[More Users]") || text.equalsIgnoreCase(Lockette.altMoreUsers)) {
                Block checkBlock = Lockette.getSignAttachedBlock(block);
                if (checkBlock == null) {
                    return;
                }
                Block signBlock = Lockette.findBlockOwner(checkBlock);
                if (signBlock == null) {
                    return;
                }
                Sign sign2 = (Sign)signBlock.getState();
                if (Lockette.isOwner(sign2, (OfflinePlayer)player)) {
                    Lockette.removeUUIDMetadata(sign);
                    plugin.localizedMessage(player, null, "msg-owner-remove");
                    return;
                }
                event.setCancelled(true);
                sign.update();
                plugin.localizedMessage(player, null, "msg-user-remove-owned", sign2.getLine(1));
            }
        } else {
            Block signBlock = Lockette.findBlockOwner(block);
            if (signBlock == null) {
                return;
            }
            Sign sign = (Sign)signBlock.getState();
            if (Lockette.isOwner(sign, (OfflinePlayer)player)) {
                signBlock = Lockette.findBlockOwnerBreak(block);
                if (signBlock != null) {
                    sign = (Sign)signBlock.getState();
                    Lockette.removeUUIDMetadata(sign);
                    Lockette.log.info("[" + plugin.getDescription().getName() + "] " + player.getName() + " has released a container.");
                } else if (BlockUtil.isInList(type, BlockUtil.materialListJustDoors)) {
                    // empty if block
                }
                return;
            }
            event.setCancelled(true);
            plugin.localizedMessage(player, null, "msg-user-break-owned", sign.getLine(1));
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        Block checkBlock;
        Block block = event.getBlock();
        List blockList = event.getBlocks();
        int count = blockList.size();
        for (int x = 0; x < count; ++x) {
            checkBlock = (Block)blockList.get(x);
            if (!Lockette.isProtected(checkBlock)) continue;
            event.setCancelled(true);
            return;
        }
        checkBlock = block.getRelative(Lockette.getPistonFacing(block), event.getLength() + 1);
        if (Lockette.isProtected(checkBlock)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        if (!event.isSticky()) {
            return;
        }
        Block block = event.getBlock();
        Block checkBlock = block.getRelative(Lockette.getPistonFacing(block), 2);
        int type = checkBlock.getTypeId();
        if (BlockUtil.isInList(type, BlockUtil.materialListNonDoors)) {
            return;
        }
        if (BlockUtil.isInList(type, BlockUtil.materialListJustDoors)) {
            return;
        }
        if (Lockette.isProtected(checkBlock)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Sign sign;
        String text;
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlockPlaced();
        int type = block.getTypeId();
        Block against = event.getBlockAgainst();
        if (against.getTypeId() == Material.WALL_SIGN.getId() && ((text = ChatColor.stripColor((String)(sign = (Sign)against.getState()).getLine(0))).equalsIgnoreCase("[Private]") || text.equalsIgnoreCase(Lockette.altPrivate) || text.equalsIgnoreCase("[More Psers]") || text.equalsIgnoreCase(Lockette.altMoreUsers))) {
            event.setCancelled(true);
            return;
        }
        if (BlockUtil.isInList(type, BlockUtil.materialListDoors)) {
            if (LocketteBlockListener.canBuildDoor(block, against, player)) {
                return;
            }
            event.setCancelled(true);
            plugin.localizedMessage(player, null, "msg-user-conflict-door");
            return;
        }
        if (Lockette.directPlacement && type == Material.WALL_SIGN.getId()) {
            Block checkBlock = Lockette.getSignAttachedBlock(block);
            if (checkBlock == null) {
                return;
            }
            type = checkBlock.getTypeId();
            if (BlockUtil.isInList(type, BlockUtil.materialListNonDoors) || Lockette.isInList(type, Lockette.customBlockList)) {
                sign = (Sign)block.getState();
                if (Lockette.isProtected(checkBlock)) {
                    if (Lockette.isOwner(checkBlock, (OfflinePlayer)player)) {
                        sign.setLine(0, Lockette.altMoreUsers);
                        sign.setLine(1, Lockette.altEveryone);
                        sign.setLine(2, "");
                        sign.setLine(3, "");
                        sign.update(true);
                        plugin.localizedMessage(player, null, "msg-owner-adduser");
                    } else {
                        event.setCancelled(true);
                    }
                    return;
                }
                if (!this.checkPermissions(player, block, checkBlock)) {
                    event.setCancelled(true);
                    plugin.localizedMessage(player, null, "msg-error-permission");
                    return;
                }
                sign.setLine(0, Lockette.altPrivate);
                Lockette.setLine(sign, 1, player.getName());
                sign.setLine(2, "");
                sign.setLine(3, "");
                sign.update(true);
                Lockette.log.info("[" + plugin.getDescription().getName() + "] " + player.getName() + " has protected a block or door.");
                plugin.localizedMessage(player, null, "msg-owner-claim");
            }
            return;
        }
        if (BlockUtil.isInList(type, BlockUtil.materialListChests)) {
            int chests = Lockette.findChestCountNear(block);
            if (chests > 1) {
                event.setCancelled(true);
                plugin.localizedMessage(player, null, "msg-user-illegal");
                return;
            }
            Block signBlock = Lockette.findBlockOwner(block);
            if (signBlock != null) {
                Sign sign2 = (Sign)signBlock.getState();
                if (Lockette.isOwner(sign2, (OfflinePlayer)player)) {
                    return;
                }
                event.setCancelled(true);
                plugin.localizedMessage(player, null, "msg-user-resize-owned", sign2.getLine(1));
            } else if (LocketteBlockListener.plugin.playerList.get(player.getName()) == null) {
                LocketteBlockListener.plugin.playerList.put(player.getName(), block);
                plugin.localizedMessage(player, null, "msg-help-chest");
            }
        }
        if (type == Material.HOPPER.getId()) {
            Block checkBlock = block.getRelative(BlockFace.UP);
            type = checkBlock.getTypeId();
            if ((BlockUtil.isInList(type, BlockUtil.materialListNonDoors) || Lockette.isInList(type, Lockette.customBlockList)) && !this.validateOwner(checkBlock, player)) {
                event.setCancelled(true);
                plugin.localizedMessage(player, null, "msg-user-denied");
                return;
            }
            checkBlock = block.getRelative(BlockFace.DOWN);
            type = checkBlock.getTypeId();
            if ((BlockUtil.isInList(type, BlockUtil.materialListNonDoors) || Lockette.isInList(type, Lockette.customBlockList)) && !this.validateOwner(checkBlock, player)) {
                event.setCancelled(true);
                plugin.localizedMessage(player, null, "msg-user-denied");
                return;
            }
        }
    }

    private boolean checkPermissions(Player player, Block block, Block checkBlock) {
        int type = checkBlock.getTypeId();
        if (plugin.usingExternalZones()) {
            if (!plugin.canBuild(player, block)) {
                plugin.localizedMessage(player, null, "msg-error-zone", PluginCore.lastZoneDeny());
                return false;
            }
            if (!plugin.canBuild(player, checkBlock)) {
                plugin.localizedMessage(player, null, "msg-error-zone", PluginCore.lastZoneDeny());
                return false;
            }
        }
        if (plugin.usingExternalPermissions()) {
            boolean create = false;
            if (plugin.hasPermission(block.getWorld(), player, "lockette.create.all")) {
                create = true;
            } else if (BlockUtil.isInList(type, BlockUtil.materialListChests)) {
                if (plugin.hasPermission(block.getWorld(), player, "lockette.user.create.chest")) {
                    create = true;
                }
            } else if (type == Material.FURNACE.getId() || type == Material.BURNING_FURNACE.getId()) {
                if (plugin.hasPermission(block.getWorld(), player, "lockette.user.create.furnace")) {
                    create = true;
                }
            } else if (type == Material.DISPENSER.getId()) {
                if (plugin.hasPermission(block.getWorld(), player, "lockette.user.create.dispenser")) {
                    create = true;
                }
            } else if (type == Material.DROPPER.getId()) {
                if (plugin.hasPermission(block.getWorld(), player, "lockette.user.create.dropper")) {
                    create = true;
                }
            } else if (type == Material.BREWING_STAND.getId()) {
                if (plugin.hasPermission(block.getWorld(), player, "lockette.user.create.brewingstand")) {
                    create = true;
                }
            } else if (Lockette.isInList(type, Lockette.customBlockList) && plugin.hasPermission(block.getWorld(), player, "lockette.user.create.custom")) {
                create = true;
            }
            return create;
        }
        return true;
    }

    private boolean validateOwner(Block block, Player player) {
        Block signBlock = Lockette.findBlockOwner(block);
        if (signBlock == null) {
            return true;
        }
        Sign sign = (Sign)signBlock.getState();
        return Lockette.isOwner(sign, (OfflinePlayer)player);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockRedstoneChange(BlockRedstoneEvent event) {
        Block block = event.getBlock();
        int type = block.getTypeId();
        boolean doCheck = false;
        if (Lockette.protectTrapDoors && BlockUtil.isInList(type, BlockUtil.materialListTrapDoors)) {
            doCheck = true;
        }
        if (Lockette.protectDoors && BlockUtil.isInList(type, BlockUtil.materialListDoors)) {
            doCheck = true;
        }
        if (doCheck) {
            String line;
            Block signBlock = Lockette.findBlockOwner(block);
            if (signBlock == null) {
                return;
            }
            Sign sign = (Sign)signBlock.getState();
            for (int y = 1; y <= 3; ++y) {
                if (sign.getLine(y).isEmpty() || !(line = ChatColor.stripColor((String)sign.getLine(y))).equalsIgnoreCase("[Everyone]") && !line.equalsIgnoreCase(Lockette.altEveryone)) continue;
                return;
            }
            List<Block> list = Lockette.findBlockUsers(block, signBlock);
            for (Block blk : list) {
                sign = (Sign)blk.getState();
                for (int y = 1; y <= 3; ++y) {
                    if (sign.getLine(y).isEmpty() || !(line = ChatColor.stripColor((String)sign.getLine(y))).equalsIgnoreCase("[Everyone]") && !line.equalsIgnoreCase(Lockette.altEveryone)) continue;
                    return;
                }
            }
            event.setNewCurrent(event.getOldCurrent());
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=false)
    public void onSignChange(SignChangeEvent event) {
        boolean typeSignPost;
        Player player = event.getPlayer();
        Block block = event.getBlock();
        int blockType = block.getTypeId();
        boolean typeWallSign = blockType == Material.WALL_SIGN.getId();
        boolean bl = typeSignPost = blockType == Material.SIGN_POST.getId();
        if (typeWallSign) {
            Sign sign = (Sign)block.getState();
            String text = ChatColor.stripColor((String)sign.getLine(0));
            if ((text.equalsIgnoreCase("[Private]") || text.equalsIgnoreCase(Lockette.altPrivate)) && LocketteBlockListener.isEmptyChange(event)) {
                event.setCancelled(true);
                return;
            }
        } else if (!typeSignPost) {
            event.setCancelled(true);
            return;
        }
        String text = ChatColor.stripColor((String)event.getLine(0));
        if (text.equalsIgnoreCase("[Private]") || text.equalsIgnoreCase(Lockette.altPrivate)) {
            Sign sign;
            int x;
            boolean doChests = true;
            boolean doFurnaces = true;
            boolean doDispensers = true;
            boolean doDroppers = true;
            boolean doBrewingStands = true;
            boolean doCustoms = true;
            boolean doTrapDoors = true;
            boolean doDoors = true;
            if (plugin.usingExternalZones() && !plugin.canBuild(player, block)) {
                event.setLine(0, "[?]");
                plugin.localizedMessage(player, null, "msg-error-zone", PluginCore.lastZoneDeny());
                return;
            }
            if (plugin.usingExternalPermissions()) {
                boolean create = false;
                doChests = false;
                doFurnaces = false;
                doDispensers = false;
                doDroppers = false;
                doBrewingStands = false;
                doCustoms = false;
                doTrapDoors = false;
                doDoors = false;
                if (plugin.hasPermission(block.getWorld(), player, "lockette.create.all")) {
                    create = true;
                    doChests = true;
                    doFurnaces = true;
                    doDispensers = true;
                    doDroppers = true;
                    doBrewingStands = true;
                    doCustoms = true;
                    doTrapDoors = true;
                    doDoors = true;
                } else {
                    if (plugin.hasPermission(block.getWorld(), player, "lockette.user.create.chest")) {
                        create = true;
                        doChests = true;
                    }
                    if (plugin.hasPermission(block.getWorld(), player, "lockette.user.create.furnace")) {
                        create = true;
                        doFurnaces = true;
                    }
                    if (plugin.hasPermission(block.getWorld(), player, "lockette.user.create.dispenser")) {
                        create = true;
                        doDispensers = true;
                    }
                    if (plugin.hasPermission(block.getWorld(), player, "lockette.user.create.dropper")) {
                        create = true;
                        doDroppers = true;
                    }
                    if (plugin.hasPermission(block.getWorld(), player, "lockette.user.create.brewingstand")) {
                        create = true;
                        doBrewingStands = true;
                    }
                    if (plugin.hasPermission(block.getWorld(), player, "lockette.user.create.custom")) {
                        create = true;
                        doCustoms = true;
                    }
                    if (plugin.hasPermission(block.getWorld(), player, "lockette.user.create.trapdoor")) {
                        create = true;
                        doTrapDoors = true;
                    }
                    if (plugin.hasPermission(block.getWorld(), player, "lockette.user.create.door")) {
                        create = true;
                        doDoors = true;
                    }
                }
                if (!create) {
                    event.setLine(0, "[?]");
                    plugin.localizedMessage(player, null, "msg-error-permission");
                    return;
                }
            }
            Block[] checkBlock = new Block[4];
            byte face = 0;
            int type = 0;
            boolean conflict = false;
            boolean deny = false;
            boolean zonedeny = false;
            if (Lockette.protectTrapDoors && typeWallSign) {
                checkBlock[3] = Lockette.getSignAttachedBlock(block);
                if (checkBlock[3] != null && !BlockUtil.isInList(checkBlock[3].getTypeId(), BlockUtil.materialListBad)) {
                    checkBlock[0] = checkBlock[3].getRelative(BlockFace.NORTH);
                    checkBlock[1] = checkBlock[3].getRelative(BlockFace.EAST);
                    checkBlock[2] = checkBlock[3].getRelative(BlockFace.SOUTH);
                    checkBlock[3] = checkBlock[3].getRelative(BlockFace.WEST);
                    for (x = 0; x < 4; ++x) {
                        if (!BlockUtil.isInList(checkBlock[x].getTypeId(), BlockUtil.materialListTrapDoors) || Lockette.findBlockOwner(checkBlock[x], block, true) != null) continue;
                        if (!doTrapDoors) {
                            deny = true;
                            continue;
                        }
                        face = block.getData();
                        type = 4;
                        break;
                    }
                }
            }
            if (Lockette.protectDoors && typeWallSign) {
                checkBlock[0] = Lockette.getSignAttachedBlock(block);
                if (checkBlock[0] != null && !BlockUtil.isInList(checkBlock[0].getTypeId(), BlockUtil.materialListBad)) {
                    checkBlock[1] = checkBlock[0].getRelative(BlockFace.UP);
                    checkBlock[2] = checkBlock[0].getRelative(BlockFace.DOWN);
                    if (BlockUtil.isInList(checkBlock[1].getTypeId(), BlockUtil.materialListDoors)) {
                        if (Lockette.findBlockOwner(checkBlock[1], block, true) == null) {
                            if (BlockUtil.isInList(checkBlock[2].getTypeId(), BlockUtil.materialListDoors)) {
                                if (Lockette.findBlockOwner(checkBlock[2], block, true) == null) {
                                    if (!doDoors) {
                                        deny = true;
                                    } else {
                                        face = block.getData();
                                        type = 5;
                                    }
                                } else {
                                    conflict = true;
                                }
                            } else if (!doDoors) {
                                deny = true;
                            } else {
                                face = block.getData();
                                type = 5;
                            }
                        } else {
                            conflict = true;
                        }
                    } else if (BlockUtil.isInList(checkBlock[2].getTypeId(), BlockUtil.materialListDoors)) {
                        if (Lockette.findBlockOwner(checkBlock[2], block, true) == null) {
                            if (!doDoors) {
                                deny = true;
                            } else {
                                face = block.getData();
                                type = 5;
                            }
                        } else {
                            conflict = true;
                        }
                    }
                }
            }
            if (conflict) {
                face = 0;
                type = 0;
            }
            if (face == 0) {
                checkBlock[0] = block.getRelative(BlockFace.NORTH);
                checkBlock[1] = block.getRelative(BlockFace.EAST);
                checkBlock[2] = block.getRelative(BlockFace.SOUTH);
                checkBlock[3] = block.getRelative(BlockFace.WEST);
                for (x = 0; x < 4; ++x) {
                    int lastType;
                    if (plugin.usingExternalZones() && !plugin.canBuild(player, checkBlock[x])) {
                        zonedeny = true;
                        continue;
                    }
                    if (BlockUtil.isInList(checkBlock[x].getTypeId(), BlockUtil.materialListChests)) {
                        if (!doChests) {
                            deny = true;
                            continue;
                        }
                        lastType = 1;
                    } else if (BlockUtil.isInList(checkBlock[x].getTypeId(), BlockUtil.materialListFurnaces)) {
                        if (!doFurnaces) {
                            deny = true;
                            continue;
                        }
                        lastType = 2;
                    } else if (checkBlock[x].getTypeId() == Material.DISPENSER.getId()) {
                        if (!doDispensers) {
                            deny = true;
                            continue;
                        }
                        lastType = 3;
                    } else if (checkBlock[x].getTypeId() == Material.DROPPER.getId()) {
                        if (!doDroppers) {
                            deny = true;
                            continue;
                        }
                        lastType = 8;
                    } else if (checkBlock[x].getTypeId() == Material.BREWING_STAND.getId()) {
                        if (!doBrewingStands) {
                            deny = true;
                            continue;
                        }
                        lastType = 6;
                    } else if (Lockette.isInList(checkBlock[x].getTypeId(), Lockette.customBlockList)) {
                        if (!doCustoms) {
                            deny = true;
                            continue;
                        }
                        lastType = 7;
                    } else if (BlockUtil.isInList(checkBlock[x].getTypeId(), BlockUtil.materialListTrapDoors)) {
                        if (!Lockette.protectTrapDoors) continue;
                        if (!doTrapDoors) {
                            deny = true;
                            continue;
                        }
                        lastType = 4;
                    } else {
                        if (!BlockUtil.isInList(checkBlock[x].getTypeId(), BlockUtil.materialListDoors) || !Lockette.protectDoors) continue;
                        if (!doDoors) {
                            deny = true;
                            continue;
                        }
                        lastType = 5;
                    }
                    if (Lockette.findBlockOwner(checkBlock[x], block, true) == null) {
                        face = BlockUtil.faceList[x];
                        type = lastType;
                        break;
                    }
                    if (Lockette.protectTrapDoors && doTrapDoors && BlockUtil.isInList(checkBlock[x].getTypeId(), BlockUtil.materialListTrapDoors)) {
                        conflict = true;
                    }
                    if (!Lockette.protectDoors || !doDoors || !BlockUtil.isInList(checkBlock[x].getTypeId(), BlockUtil.materialListDoors)) continue;
                    conflict = true;
                }
            }
            if (face == 0) {
                event.setLine(0, "[?]");
                if (conflict) {
                    plugin.localizedMessage(player, null, "msg-error-claim-conflict");
                } else if (zonedeny) {
                    plugin.localizedMessage(player, null, "msg-error-zone", PluginCore.lastZoneDeny());
                } else if (deny) {
                    plugin.localizedMessage(player, null, "msg-error-permission");
                } else {
                    plugin.localizedMessage(player, null, "msg-error-claim");
                }
                return;
            }
            boolean anyone = true;
            if (Lockette.DEBUG) {
                Lockette.log.info("[Lockette] creating new Lockette sign");
                Lockette.log.info("[Lockette] 1st line = " + event.getLine(1));
            }
            if (event.getLine(1).isEmpty()) {
                anyone = false;
            }
            event.setCancelled(false);
            if (anyone) {
                if (type == 1) {
                    if (!plugin.hasPermission(block.getWorld(), player, "lockette.admin.create.chest")) {
                        anyone = false;
                    }
                } else if (type == 2) {
                    if (!plugin.hasPermission(block.getWorld(), player, "lockette.admin.create.furnace")) {
                        anyone = false;
                    }
                } else if (type == 3) {
                    if (!plugin.hasPermission(block.getWorld(), player, "lockette.admin.create.dispenser")) {
                        anyone = false;
                    }
                } else if (type == 8) {
                    if (!plugin.hasPermission(block.getWorld(), player, "lockette.admin.create.dropper")) {
                        anyone = false;
                    }
                } else if (type == 6) {
                    if (!plugin.hasPermission(block.getWorld(), player, "lockette.admin.create.brewingstand")) {
                        anyone = false;
                    }
                } else if (type == 7) {
                    if (!plugin.hasPermission(block.getWorld(), player, "lockette.admin.create.custom")) {
                        anyone = false;
                    }
                } else if (type == 4) {
                    if (!plugin.hasPermission(block.getWorld(), player, "lockette.admin.create.trapdoor")) {
                        anyone = false;
                    }
                } else if (type == 5) {
                    if (!plugin.hasPermission(block.getWorld(), player, "lockette.admin.create.door")) {
                        anyone = false;
                    }
                } else {
                    anyone = false;
                }
            }
            if (!anyone) {
                sign = (Sign)block.getState();
                if (Lockette.DEBUG) {
                    Lockette.log.info("[Lockette] Setting palyer's name : " + player.getName());
                }
                Lockette.setLine(sign, 1, player.getName());
                event.setLine(1, player.getName());
                sign.update(true);
            } else {
                sign = (Sign)block.getState();
                if (Lockette.DEBUG) {
                    Lockette.log.info("[Lockette] Setting other's name : " + event.getLine(1));
                }
                Lockette.setLine(sign, 1, event.getLine(1));
                event.setLine(1, event.getLine(1));
            }
            if (!typeWallSign) {
                block.setType(Material.WALL_SIGN);
                block.setData(face);
                sign = (Sign)block.getState();
                sign.setLine(0, event.getLine(0));
                Lockette.setLine(sign, 1, event.getLine(1));
                Lockette.setLine(sign, 2, event.getLine(2));
                Lockette.setLine(sign, 3, event.getLine(3));
                sign.update(true);
            } else {
                block.setData(face);
            }
            if (anyone) {
                Lockette.log.info("[" + plugin.getDescription().getName() + "] (Admin) " + player.getName() + " has claimed a container for " + event.getLine(1) + ".");
                if (!plugin.playerOnline(event.getLine(1))) {
                    plugin.localizedMessage(player, null, "msg-admin-claim-error", event.getLine(1));
                } else {
                    plugin.localizedMessage(player, null, "msg-admin-claim", event.getLine(1));
                }
            } else {
                Lockette.log.info("[" + plugin.getDescription().getName() + "] " + player.getName() + " has claimed a container.");
                plugin.localizedMessage(player, null, "msg-owner-claim");
            }
        } else if (text.equalsIgnoreCase("[More Users]") || text.equalsIgnoreCase(Lockette.altMoreUsers)) {
            Block[] checkBlock = new Block[4];
            Block signBlock = null;
            Sign sign = null;
            byte face = 0;
            if ((Lockette.protectDoors || Lockette.protectTrapDoors) && typeWallSign) {
                checkBlock[0] = Lockette.getSignAttachedBlock(block);
                if (checkBlock[0] != null && !BlockUtil.isInList(checkBlock[0].getTypeId(), BlockUtil.materialListBad) && (signBlock = Lockette.findBlockOwner(checkBlock[0])) != null && Lockette.isOwner(sign = (Sign)signBlock.getState(), (OfflinePlayer)player)) {
                    face = block.getData();
                }
            }
            if (face == 0) {
                checkBlock[0] = block.getRelative(BlockFace.NORTH);
                checkBlock[1] = block.getRelative(BlockFace.EAST);
                checkBlock[2] = block.getRelative(BlockFace.SOUTH);
                checkBlock[3] = block.getRelative(BlockFace.WEST);
                for (int x = 0; x < 4; ++x) {
                    if (!BlockUtil.isInList(checkBlock[x].getTypeId(), BlockUtil.materialList) || !Lockette.protectTrapDoors && BlockUtil.isInList(checkBlock[x].getTypeId(), BlockUtil.materialListTrapDoors) || !Lockette.protectDoors && BlockUtil.isInList(checkBlock[x].getTypeId(), BlockUtil.materialListDoors) || (signBlock = Lockette.findBlockOwner(checkBlock[x])) == null || !Lockette.isOwner(sign = (Sign)signBlock.getState(), (OfflinePlayer)player)) continue;
                    face = BlockUtil.faceList[x];
                    break;
                }
            }
            if (face == 0) {
                event.setLine(0, "[?]");
                if (sign != null) {
                    plugin.localizedMessage(player, null, "msg-error-adduser-owned", sign.getLine(1));
                } else {
                    plugin.localizedMessage(player, null, "msg-error-adduser");
                }
                return;
            }
            event.setCancelled(false);
            if (!typeWallSign) {
                block.setType(Material.WALL_SIGN);
                block.setData(face);
                sign = (Sign)block.getState();
                sign.setLine(0, event.getLine(0));
                Lockette.setLine(sign, 1, event.getLine(1));
                Lockette.setLine(sign, 2, event.getLine(2));
                Lockette.setLine(sign, 3, event.getLine(2));
                sign.update(true);
            } else {
                block.setData(face);
            }
            plugin.localizedMessage(player, null, "msg-owner-adduser");
        }
    }

    private static boolean canBuildDoor(Block block, Block against, Player player) {
        if (!Lockette.isOwner(against, (OfflinePlayer)player)) {
            return false;
        }
        if (Lockette.protectTrapDoors && BlockUtil.isInList(block.getTypeId(), BlockUtil.materialListTrapDoors)) {
            return true;
        }
        if (!Lockette.isOwner(against.getRelative(BlockFace.UP, 3), (OfflinePlayer)player)) {
            return false;
        }
        Block checkBlock = block.getRelative(BlockFace.NORTH);
        if (checkBlock.getTypeId() == block.getTypeId() && !Lockette.isOwner(checkBlock, (OfflinePlayer)player)) {
            return false;
        }
        checkBlock = block.getRelative(BlockFace.EAST);
        if (checkBlock.getTypeId() == block.getTypeId() && !Lockette.isOwner(checkBlock, (OfflinePlayer)player)) {
            return false;
        }
        checkBlock = block.getRelative(BlockFace.SOUTH);
        if (checkBlock.getTypeId() == block.getTypeId() && !Lockette.isOwner(checkBlock, (OfflinePlayer)player)) {
            return false;
        }
        checkBlock = block.getRelative(BlockFace.WEST);
        return checkBlock.getTypeId() != block.getTypeId() || Lockette.isOwner(checkBlock, (OfflinePlayer)player);
    }

    static boolean isEmptyChange(SignChangeEvent signe) {
        for (int i = 0; i < 4; ++i) {
            String str = ChatColor.stripColor((String)signe.getLine(i));
            if (str.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

