/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.demo;

import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import com.googlecode.vfsjfilechooser2.accessories.DefaultAccessoriesPanel;
import com.googlecode.vfsjfilechooser2.utils.VFSResources;
import com.googlecode.vfsjfilechooser2.utils.VFSUtils;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextField;
import org.apache.commons.vfs2.FileObject;

public final class Main
extends JFrame
implements Runnable {
    private VFSJFileChooser fileChooser;
    private JTextField filenameTextField;
    private JButton openButton;
    private String buttonText;

    public Main() {
        super("VFSJFileChooser Demo");
        this.setDefaultCloseOperation(3);
        this.createGUI();
    }

    private void createGUI() {
        this.fileChooser = new VFSJFileChooser();
        this.fileChooser.setAccessory(new DefaultAccessoriesPanel(this.fileChooser));
        this.fileChooser.setFileHidingEnabled(false);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileSelectionMode(VFSJFileChooser.SELECTION_MODE.FILES_ONLY);
        this.filenameTextField = new JTextField(40);
        this.buttonText = VFSResources.getMessage("VFSJFileChooser.directoryOpenButtonText");
        this.openButton = new JButton(new OpenAction(this.buttonText));
        this.getContentPane().add((Component)this.openButton, "West");
        this.getContentPane().add((Component)this.filenameTextField, "Center");
        this.pack();
    }

    @Override
    public void run() {
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
        this.toFront();
    }

    public static void main(String[] args) throws Exception {
        EventQueue.invokeLater(new Main());
    }

    private class OpenAction
    extends AbstractAction {
        public OpenAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            VFSJFileChooser.RETURN_TYPE answer = Main.this.fileChooser.showOpenDialog(Main.this);
            if (answer == VFSJFileChooser.RETURN_TYPE.APPROVE) {
                FileObject aFileObject = Main.this.fileChooser.getSelectedFileObject();
                String safeName = VFSUtils.getFriendlyName(aFileObject.toString());
                Main.this.filenameTextField.setText(safeName);
            }
        }
    }
}

