/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.datastructures;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.StringCompatible;
import com.github.fppt.jedismock.exception.WrongValueTypeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class RMHyperLogLog
extends StringCompatible
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient HashSet<Slice> storedData = new HashSet();

    public Set<Slice> getStoredData() {
        return this.storedData;
    }

    public int size() {
        return this.storedData.size();
    }

    public void addAll(Collection<Slice> data) {
        this.storedData.addAll(data);
    }

    @Override
    public void raiseTypeCastException() {
        throw new WrongValueTypeException("WRONGTYPE HyperLogLog is used in the wrong place");
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.storedData.size());
        for (Slice storedDatum : this.storedData) {
            s.writeInt(storedDatum.length());
            for (byte datum : storedDatum.data()) {
                s.writeByte(datum);
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.storedData = new HashSet();
        s.defaultReadObject();
        int count = s.readInt();
        for (int i = 0; i < count; ++i) {
            int len = s.readInt();
            byte[] buf = new byte[len];
            for (int j = 0; j < len; ++j) {
                buf[j] = s.readByte();
            }
            this.storedData.add(Slice.create(buf));
        }
    }

    @Override
    public final Slice getAsSlice() {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream outputStream = new ObjectOutputStream(byteOutputStream);
            outputStream.writeObject(this);
            return Slice.create(byteOutputStream.toByteArray());
        }
        catch (IOException exp) {
            throw new IllegalStateException(exp);
        }
    }
}

