/*
 * Decompiled with CFR 0.152.
 */
package soup.neumorphism.internal.shape;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import soup.neumorphism.LightSource;
import soup.neumorphism.NeumorphShapeAppearanceModel;
import soup.neumorphism.NeumorphShapeDrawable;
import soup.neumorphism.internal.blur.BlurProvider;
import soup.neumorphism.internal.shape.Shape;
import soup.neumorphism.internal.util.CanvasCompat;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u0006*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lsoup/neumorphism/internal/shape/FlatShape;", "Lsoup/neumorphism/internal/shape/Shape;", "drawableState", "Lsoup/neumorphism/NeumorphShapeDrawable$NeumorphShapeDrawableState;", "(Lsoup/neumorphism/NeumorphShapeDrawable$NeumorphShapeDrawableState;)V", "darkShadowBitmap", "Landroid/graphics/Bitmap;", "darkShadowDrawable", "Landroid/graphics/drawable/GradientDrawable;", "lightShadowBitmap", "lightShadowDrawable", "draw", "", "canvas", "Landroid/graphics/Canvas;", "outlinePath", "Landroid/graphics/Path;", "setDrawableState", "newDrawableState", "updateShadowBitmap", "bounds", "Landroid/graphics/Rect;", "toBlurredBitmap", "Landroid/graphics/drawable/Drawable;", "w", "", "h", "neumorphism_release"})
public final class FlatShape
implements Shape {
    private Bitmap lightShadowBitmap;
    private Bitmap darkShadowBitmap;
    private final GradientDrawable lightShadowDrawable;
    private final GradientDrawable darkShadowDrawable;
    private NeumorphShapeDrawable.NeumorphShapeDrawableState drawableState;

    @Override
    public void setDrawableState(@NotNull NeumorphShapeDrawable.NeumorphShapeDrawableState newDrawableState) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)newDrawableState), (String)"newDrawableState");
        this.drawableState = newDrawableState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(@NotNull Canvas canvas, @NotNull Path outlinePath) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)outlinePath, (String)"outlinePath");
        Canvas $this$withClipOut$iv = canvas;
        boolean $i$f$withClipOut = false;
        int checkpoint$iv = $this$withClipOut$iv.save();
        CanvasCompat.INSTANCE.clipOutPath($this$withClipOut$iv, outlinePath);
        try {
            float offsetY;
            float offsetX;
            Bitmap it;
            boolean bl;
            boolean bl2;
            Bitmap bitmap;
            Canvas $this$withClipOut = $this$withClipOut$iv;
            boolean bl3 = false;
            int lightSource = this.drawableState.getLightSource();
            float elevation = this.drawableState.getShadowElevation();
            float z = this.drawableState.getShadowElevation() + this.drawableState.getTranslationZ();
            Rect inset = this.drawableState.getInset();
            float left = inset.left;
            float top = inset.top;
            Bitmap bitmap2 = this.lightShadowBitmap;
            if (bitmap2 != null) {
                bitmap = bitmap2;
                bl2 = false;
                bl = false;
                it = bitmap;
                boolean bl4 = false;
                offsetX = LightSource.Companion.isLeft(lightSource) ? -elevation - z : -elevation + z;
                offsetY = LightSource.Companion.isTop(lightSource) ? -elevation - z : -elevation + z;
                $this$withClipOut.drawBitmap(it, offsetX + left, offsetY + top, null);
            }
            Bitmap bitmap3 = this.darkShadowBitmap;
            if (bitmap3 != null) {
                bitmap = bitmap3;
                bl2 = false;
                bl = false;
                it = bitmap;
                boolean bl5 = false;
                offsetX = LightSource.Companion.isLeft(lightSource) ? -elevation + z : -elevation - z;
                offsetY = LightSource.Companion.isTop(lightSource) ? -elevation + z : -elevation - z;
                $this$withClipOut.drawBitmap(it, offsetX + left, offsetY + top, null);
            }
        }
        finally {
            $this$withClipOut$iv.restoreToCount(checkpoint$iv);
        }
    }

    @Override
    public void updateShadowBitmap(@NotNull Rect bounds) {
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        Function2<GradientDrawable, NeumorphShapeAppearanceModel, Unit> $fun$setCornerShape$1 = new Function2<GradientDrawable, NeumorphShapeAppearanceModel, Unit>(bounds){
            final /* synthetic */ Rect $bounds;

            public final void invoke(@NotNull GradientDrawable $this$setCornerShape, @NotNull NeumorphShapeAppearanceModel shapeAppearanceModel) {
                Intrinsics.checkParameterIsNotNull((Object)$this$setCornerShape, (String)"$this$setCornerShape");
                Intrinsics.checkParameterIsNotNull((Object)shapeAppearanceModel, (String)"shapeAppearanceModel");
                switch (shapeAppearanceModel.getCornerFamily()) {
                    case 1: {
                        $this$setCornerShape.setShape(1);
                        break;
                    }
                    case 0: {
                        $this$setCornerShape.setShape(0);
                        float f = (float)this.$bounds.width() / 2.0f;
                        float f2 = (float)this.$bounds.height() / 2.0f;
                        NeumorphShapeAppearanceModel neumorphShapeAppearanceModel = shapeAppearanceModel;
                        GradientDrawable gradientDrawable = $this$setCornerShape;
                        boolean bl = false;
                        float f3 = Math.min(f, f2);
                        gradientDrawable.setCornerRadii(neumorphShapeAppearanceModel.getCornerRadii$neumorphism_release(f3));
                        break;
                    }
                }
            }
            {
                this.$bounds = rect;
                super(2);
            }
        };
        GradientDrawable gradientDrawable = this.lightShadowDrawable;
        boolean bl = false;
        boolean bl2 = false;
        GradientDrawable $this$apply = gradientDrawable;
        boolean bl3 = false;
        $this$apply.setColor(this.drawableState.getShadowColorLight());
        $fun$setCornerShape$1.invoke($this$apply, this.drawableState.getShapeAppearanceModel());
        gradientDrawable = this.darkShadowDrawable;
        bl = false;
        bl2 = false;
        $this$apply = gradientDrawable;
        boolean bl4 = false;
        $this$apply.setColor(this.drawableState.getShadowColorDark());
        $fun$setCornerShape$1.invoke($this$apply, this.drawableState.getShapeAppearanceModel());
        int w = bounds.width();
        int h = bounds.height();
        this.lightShadowDrawable.setSize(w, h);
        this.lightShadowDrawable.setBounds(0, 0, w, h);
        this.darkShadowDrawable.setSize(w, h);
        this.darkShadowDrawable.setBounds(0, 0, w, h);
        this.lightShadowBitmap = this.toBlurredBitmap((Drawable)this.lightShadowDrawable, w, h);
        this.darkShadowBitmap = this.toBlurredBitmap((Drawable)this.darkShadowDrawable, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Bitmap toBlurredBitmap(@NotNull Drawable $this$toBlurredBitmap, int w, int h) {
        void x$iv;
        void $this$withTranslation$iv;
        void $this$onCanvas$iv;
        Function1<Bitmap, Bitmap> $fun$blurred$1 = new Function1<Bitmap, Bitmap>(this){
            final /* synthetic */ FlatShape this$0;

            @Nullable
            public final Bitmap invoke(@NotNull Bitmap $this$blurred) {
                Intrinsics.checkParameterIsNotNull((Object)$this$blurred, (String)"$this$blurred");
                if (FlatShape.access$getDrawableState$p(this.this$0).getInEditMode()) {
                    return $this$blurred;
                }
                return BlurProvider.blur$default(FlatShape.access$getDrawableState$p(this.this$0).getBlurProvider(), $this$blurred, 0, 0, 6, null);
            }
            {
                this.this$0 = flatShape;
                super(1);
            }
        };
        float shadowElevation = this.drawableState.getShadowElevation();
        int width = MathKt.roundToInt((float)((float)w + shadowElevation * (float)2));
        int height = MathKt.roundToInt((float)((float)h + shadowElevation * (float)2));
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createBitmap(widt\u2026 Bitmap.Config.ARGB_8888)");
        Bitmap bitmap2 = bitmap;
        Function1<Bitmap, Bitmap> function1 = $fun$blurred$1;
        boolean $i$f$onCanvas = false;
        void var10_11 = $this$onCanvas$iv;
        boolean bl = false;
        boolean bl2 = false;
        void it$iv = var10_11;
        boolean bl3 = false;
        Canvas canvas = new Canvas((Bitmap)it$iv);
        boolean bl4 = false;
        boolean bl5 = false;
        Canvas $this$onCanvas = canvas;
        boolean bl6 = false;
        Canvas canvas2 = $this$onCanvas;
        float f = shadowElevation;
        float y$iv = shadowElevation;
        boolean $i$f$withTranslation = false;
        int checkpoint$iv = $this$withTranslation$iv.save();
        $this$withTranslation$iv.translate((float)x$iv, y$iv);
        try {
            void $this$withTranslation = $this$withTranslation$iv;
            boolean bl7 = false;
            $this$toBlurredBitmap.draw((Canvas)$this$withTranslation);
        }
        finally {
            $this$withTranslation$iv.restoreToCount(checkpoint$iv);
        }
        void var28_29 = var10_11;
        return function1.invoke((Bitmap)var28_29);
    }

    public FlatShape(@NotNull NeumorphShapeDrawable.NeumorphShapeDrawableState drawableState) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)drawableState), (String)"drawableState");
        this.drawableState = drawableState;
        this.lightShadowDrawable = new GradientDrawable();
        this.darkShadowDrawable = new GradientDrawable();
    }

    public static final /* synthetic */ NeumorphShapeDrawable.NeumorphShapeDrawableState access$getDrawableState$p(FlatShape $this) {
        return $this.drawableState;
    }

    public static final /* synthetic */ void access$setDrawableState$p(FlatShape $this, NeumorphShapeDrawable.NeumorphShapeDrawableState neumorphShapeDrawableState) {
        $this.drawableState = neumorphShapeDrawableState;
    }
}

