/*
 * Decompiled with CFR 0.152.
 */
package soup.neumorphism.internal.blur;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.os.Build;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.renderscript.Type;
import android.util.DisplayMetrics;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import soup.neumorphism.internal.blur.BlurFactor;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\tJ\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\tH\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lsoup/neumorphism/internal/blur/BlurProvider;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "contextRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "defaultBlurRadius", "", "blur", "Landroid/graphics/Bitmap;", "source", "radius", "sampling", "factor", "Lsoup/neumorphism/internal/blur/BlurFactor;", "rs", "bitmap", "stack", "sentBitmap", "canReuseInBitmap", "", "neumorphism_release"})
public final class BlurProvider {
    private final WeakReference<Context> contextRef;
    private final int defaultBlurRadius;

    @Nullable
    public final Bitmap blur(@NotNull Bitmap source, int radius, int sampling) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        BlurFactor factor = new BlurFactor(source.getWidth(), source.getHeight(), radius, sampling, 0, 16, null);
        return this.blur(source, factor);
    }

    public static /* synthetic */ Bitmap blur$default(BlurProvider blurProvider, Bitmap bitmap, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = blurProvider.defaultBlurRadius;
        }
        if ((n3 & 4) != 0) {
            n2 = 1;
        }
        return blurProvider.blur(bitmap, n, n2);
    }

    private final Bitmap blur(Bitmap source, BlurFactor factor) {
        Bitmap bitmap;
        Bitmap blurBitmap;
        Bitmap bitmap2;
        int width = factor.getWidth() / factor.getSampling();
        int height = factor.getHeight() / factor.getSampling();
        if (width == 0 || height == 0) {
            return null;
        }
        Bitmap bitmap3 = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"Bitmap.createBitmap(widt\u2026 Bitmap.Config.ARGB_8888)");
        Bitmap $this$onCanvas$iv = bitmap3;
        boolean $i$f$onCanvas = false;
        Bitmap bitmap4 = $this$onCanvas$iv;
        boolean bl = false;
        boolean bl2 = false;
        Bitmap it$iv = bitmap4;
        boolean bl3 = false;
        Canvas canvas = new Canvas(it$iv);
        boolean bl4 = false;
        boolean bl5 = false;
        Canvas $this$onCanvas = canvas;
        boolean bl6 = false;
        $this$onCanvas.scale(1.0f / (float)factor.getSampling(), 1.0f / (float)factor.getSampling());
        Paint paint = new Paint();
        boolean bl7 = false;
        boolean bl8 = false;
        Paint $this$apply = paint;
        boolean bl9 = false;
        $this$apply.setFlags(3);
        $this$apply.setColorFilter((ColorFilter)new PorterDuffColorFilter(factor.getColor(), PorterDuff.Mode.SRC_ATOP));
        Paint paint2 = paint;
        $this$onCanvas.drawBitmap(source, 0.0f, 0.0f, paint2);
        Bitmap bitmap5 = bitmap4;
        try {
            bitmap2 = this.rs(bitmap5, factor.getRadius());
        }
        catch (RSRuntimeException e) {
            bitmap2 = this.stack(bitmap5, factor.getRadius(), true);
        }
        Bitmap bitmap6 = blurBitmap = bitmap2;
        if (bitmap6 != null) {
            bitmap2 = bitmap6;
            boolean bl10 = false;
            bl = false;
            Bitmap it = bitmap2;
            boolean bl11 = false;
            if (factor.getSampling() == 1) {
                bitmap = it;
            } else {
                Bitmap scaled = Bitmap.createScaledBitmap((Bitmap)it, (int)factor.getWidth(), (int)factor.getHeight(), (boolean)true);
                it.recycle();
                bitmap = scaled;
            }
        } else {
            bitmap = null;
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bitmap rs(Bitmap bitmap, int radius) throws RSRuntimeException {
        Context context = (Context)this.contextRef.get();
        if (context == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"contextRef.get() ?: return null");
        Context context2 = context;
        RenderScript rs = null;
        Allocation input = null;
        Allocation output = null;
        ScriptIntrinsicBlur blur = null;
        try {
            RenderScript renderScript = rs = RenderScript.create((Context)context2);
            Intrinsics.checkExpressionValueIsNotNull((Object)renderScript, (String)"rs");
            renderScript.setMessageHandler(new RenderScript.RSMessageHandler());
            Allocation allocation = input = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)bitmap, (Allocation.MipmapControl)Allocation.MipmapControl.MIPMAP_NONE, (int)1);
            Intrinsics.checkExpressionValueIsNotNull((Object)allocation, (String)"input");
            output = Allocation.createTyped((RenderScript)rs, (Type)allocation.getType());
            blur = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
            blur.setInput(input);
            blur.setRadius((float)radius);
            blur.forEach(output);
            output.copyTo(bitmap);
        }
        catch (Throwable throwable) {
            RenderScript renderScript = rs;
            if (renderScript != null) {
                renderScript.destroy();
            }
            Allocation allocation = input;
            if (allocation != null) {
                allocation.destroy();
            }
            Allocation allocation2 = output;
            if (allocation2 != null) {
                allocation2.destroy();
            }
            ScriptIntrinsicBlur scriptIntrinsicBlur = blur;
            if (scriptIntrinsicBlur != null) {
                scriptIntrinsicBlur.destroy();
            }
            throw throwable;
        }
        rs.destroy();
        input.destroy();
        Allocation allocation = output;
        if (allocation != null) {
            allocation.destroy();
        }
        ScriptIntrinsicBlur scriptIntrinsicBlur = blur;
        if (scriptIntrinsicBlur != null) {
            scriptIntrinsicBlur.destroy();
        }
        return bitmap;
    }

    private final Bitmap stack(Bitmap sentBitmap, int radius, boolean canReuseInBitmap) {
        Object object;
        int n;
        Bitmap bitmap;
        if (radius < 1) {
            return null;
        }
        if (canReuseInBitmap) {
            bitmap = sentBitmap;
        } else {
            Bitmap bitmap2 = sentBitmap.copy(sentBitmap.getConfig(), true);
            bitmap = bitmap2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"sentBitmap.copy(sentBitmap.config, true)");
        }
        Bitmap bitmap3 = bitmap;
        int w = bitmap3.getWidth();
        int h = bitmap3.getHeight();
        int[] pix = new int[w * h];
        bitmap3.getPixels(pix, 0, w, 0, 0, w, h);
        int wm = w - 1;
        int hm = h - 1;
        int wh = w * h;
        int div = radius + radius + 1;
        int[] r = new int[wh];
        int[] g = new int[wh];
        int[] b = new int[wh];
        int rsum = 0;
        int gsum = 0;
        int bsum = 0;
        int x = 0;
        int y = 0;
        int i = 0;
        boolean bl = false;
        int yp = 0;
        int yi = 0;
        int yw = 0;
        boolean bl2 = false;
        int[] vmin = new int[Math.max(w, h)];
        int divsum = div + 1 >> 1;
        divsum *= divsum;
        int[] dv = new int[256 * divsum];
        for (i = 0; i < 256 * divsum; ++i) {
            dv[i] = i / divsum;
        }
        yw = yi = 0;
        int[][] nArrayArray = new int[div][];
        int n2 = 0;
        while (n2 < div) {
            int n3 = n2;
            n = n2++;
            object = nArrayArray;
            boolean bl22 = false;
            int[] nArray = new int[3];
            object[n] = nArray;
        }
        int[][] stack = nArrayArray;
        int stackpointer = 0;
        int stackstart = 0;
        int[] sir = null;
        int rbs = 0;
        int r1 = radius + 1;
        int routsum = 0;
        int goutsum = 0;
        int boutsum = 0;
        int rinsum = 0;
        int ginsum = 0;
        int binsum = 0;
        for (y = 0; y < h; ++y) {
            Object object2;
            rinsum = ginsum = (binsum = (routsum = (goutsum = (boutsum = (rsum = (gsum = (bsum = 0)))))));
            for (i = -radius; i <= radius; ++i) {
                int n4;
                int n5 = 0;
                n = yi;
                object = pix;
                boolean bl3 = false;
                n5 = n4 = Math.max(i, n5);
                bl3 = false;
                n4 = Math.min(wm, n5);
                object2 = object[n + n4];
                sir = stack[i + radius];
                sir[0] = (object2 & 0xFF0000) >> 16;
                sir[1] = (object2 & 0xFF00) >> 8;
                sir[2] = object2 & 0xFF;
                rbs = r1 - Math.abs(i);
                rsum += sir[0] * rbs;
                gsum += sir[1] * rbs;
                bsum += sir[2] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                    continue;
                }
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
            }
            stackpointer = radius;
            for (x = 0; x < w; ++x) {
                r[yi] = dv[rsum];
                g[yi] = dv[gsum];
                b[yi] = dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (y == 0) {
                    vmin[x] = Math.min(x + radius + 1, wm);
                }
                object2 = pix[yw + vmin[x]];
                sir[0] = (object2 & 0xFF0000) >> 16;
                sir[1] = (object2 & 0xFF00) >> 8;
                sir[2] = object2 & 0xFF;
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer % div];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                ++yi;
            }
            yw += w;
        }
        for (x = 0; x < w; ++x) {
            rinsum = ginsum = (binsum = (routsum = (goutsum = (boutsum = (rsum = (gsum = (bsum = 0)))))));
            yp = -radius * w;
            for (i = -radius; i <= radius; ++i) {
                yi = Math.max(0, yp) + x;
                sir = stack[i + radius];
                sir[0] = r[yi];
                sir[1] = g[yi];
                sir[2] = b[yi];
                rbs = r1 - Math.abs(i);
                rsum += r[yi] * rbs;
                gsum += g[yi] * rbs;
                bsum += b[yi] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                } else {
                    routsum += sir[0];
                    goutsum += sir[1];
                    boutsum += sir[2];
                }
                if (i >= hm) continue;
                yp += w;
            }
            yi = x;
            stackpointer = radius;
            for (y = 0; y < h; ++y) {
                pix[yi] = 0xFF000000 & pix[yi] | dv[rsum] << 16 | dv[gsum] << 8 | dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (x == 0) {
                    vmin[y] = Math.min(y + r1, hm) * w;
                }
                int n6 = x + vmin[y];
                sir[0] = r[n6];
                sir[1] = g[n6];
                sir[2] = b[n6];
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                yi += w;
            }
        }
        bitmap3.setPixels(pix, 0, w, 0, 0, w, h);
        return bitmap3;
    }

    public BlurProvider(@NotNull Context context) {
        int n;
        float f;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.contextRef = new WeakReference<Context>(context);
        if (Build.VERSION.SDK_INT >= 24) {
            f = (float)DisplayMetrics.DENSITY_DEVICE_STABLE / (float)160;
        } else {
            Resources resources = context.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
            f = resources.getDisplayMetrics().density;
        }
        float densityStable = f;
        int n2 = 25;
        int n3 = MathKt.roundToInt((float)(densityStable * (float)10));
        BlurProvider blurProvider = this;
        boolean bl = false;
        blurProvider.defaultBlurRadius = n = Math.min(n2, n3);
    }
}

