/*
 * Decompiled with CFR 0.152.
 */
package soup.neumorphism;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import androidx.annotation.ColorInt;
import androidx.appcompat.widget.AppCompatButton;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import soup.neumorphism.NeumorphShapeAppearanceModel;
import soup.neumorphism.NeumorphShapeDrawable;
import soup.neumorphism.R;
import soup.neumorphism.internal.util.NeumorphResources;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0019\u0018\u0000 <2\u00020\u0001:\u0001<B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0007J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013J\u0006\u0010\u001b\u001a\u00020\u0016J(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007H\u0002J\u0012\u0010\"\u001a\u00020\u001d2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0010\u0010%\u001a\u00020\u001d2\b\u0010&\u001a\u0004\u0018\u00010\u0013J\u0010\u0010%\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u0007H\u0016J\u0012\u0010(\u001a\u00020\u001d2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0012\u0010)\u001a\u00020\u001d2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J&\u0010*\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007J\u000e\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u0007J\u0010\u0010-\u001a\u00020\u001d2\b\b\u0001\u0010.\u001a\u00020\u0007J\u0010\u0010/\u001a\u00020\u001d2\b\b\u0001\u0010.\u001a\u00020\u0007J\u000e\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u0016J\u000e\u00102\u001a\u00020\u001d2\u0006\u00103\u001a\u00020\u0018J\u000e\u00104\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u0007J\u0010\u00106\u001a\u00020\u001d2\b\u00107\u001a\u0004\u0018\u00010\u0013J\u000e\u00108\u001a\u00020\u001d2\u0006\u00109\u001a\u00020\u0016J\u0010\u0010:\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020\u0016H\u0016R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lsoup/neumorphism/NeumorphButton;", "Landroidx/appcompat/widget/AppCompatButton;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "insetBottom", "insetEnd", "insetStart", "insetTop", "isInitialized", "", "shapeDrawable", "Lsoup/neumorphism/NeumorphShapeDrawable;", "getBackgroundColor", "Landroid/content/res/ColorStateList;", "getLightSource", "getShadowElevation", "", "getShapeAppearanceModel", "Lsoup/neumorphism/NeumorphShapeAppearanceModel;", "getShapeType", "getStrokeColor", "getStrokeWidth", "internalSetInset", "", "left", "top", "right", "bottom", "setBackground", "drawable", "Landroid/graphics/drawable/Drawable;", "setBackgroundColor", "backgroundColor", "color", "setBackgroundDrawable", "setBackgroundInternal", "setInset", "setLightSource", "lightSource", "setShadowColorDark", "shadowColor", "setShadowColorLight", "setShadowElevation", "shadowElevation", "setShapeAppearanceModel", "shapeAppearanceModel", "setShapeType", "shapeType", "setStrokeColor", "strokeColor", "setStrokeWidth", "strokeWidth", "setTranslationZ", "translationZ", "Companion", "neumorphism_release"})
public final class NeumorphButton
extends AppCompatButton {
    private boolean isInitialized;
    private final NeumorphShapeDrawable shapeDrawable;
    private int insetStart;
    private int insetEnd;
    private int insetTop;
    private int insetBottom;
    private static final String LOG_TAG = "NeumorphButton";
    public static final Companion Companion = new Companion(null);

    public void setBackground(@Nullable Drawable drawable) {
        this.setBackgroundDrawable(drawable);
    }

    public void setBackgroundDrawable(@Nullable Drawable drawable) {
        Log.i((String)LOG_TAG, (String)"Setting a custom background is not supported.");
    }

    private final void setBackgroundInternal(Drawable drawable) {
        super.setBackgroundDrawable(drawable);
    }

    public final void setShapeAppearanceModel(@NotNull NeumorphShapeAppearanceModel shapeAppearanceModel) {
        Intrinsics.checkParameterIsNotNull((Object)shapeAppearanceModel, (String)"shapeAppearanceModel");
        this.shapeDrawable.setShapeAppearanceModel(shapeAppearanceModel);
    }

    @NotNull
    public final NeumorphShapeAppearanceModel getShapeAppearanceModel() {
        return this.shapeDrawable.getShapeAppearanceModel();
    }

    public void setBackgroundColor(int color2) {
        this.shapeDrawable.setFillColor(ColorStateList.valueOf((int)color2));
    }

    public final void setBackgroundColor(@Nullable ColorStateList backgroundColor) {
        this.shapeDrawable.setFillColor(backgroundColor);
    }

    @Nullable
    public final ColorStateList getBackgroundColor() {
        return this.shapeDrawable.getFillColor();
    }

    public final void setStrokeColor(@Nullable ColorStateList strokeColor) {
        this.shapeDrawable.setStrokeColor(strokeColor);
    }

    @Nullable
    public final ColorStateList getStrokeColor() {
        return this.shapeDrawable.getStrokeColor();
    }

    public final void setStrokeWidth(float strokeWidth) {
        this.shapeDrawable.setStrokeWidth(strokeWidth);
    }

    public final float getStrokeWidth() {
        return this.shapeDrawable.getStrokeWidth();
    }

    public final void setLightSource(int lightSource) {
        this.shapeDrawable.setLightSource(lightSource);
    }

    public final int getLightSource() {
        return this.shapeDrawable.getLightSource();
    }

    public final void setShapeType(int shapeType) {
        this.shapeDrawable.setShapeType(shapeType);
    }

    public final int getShapeType() {
        return this.shapeDrawable.getShapeType();
    }

    public final void setInset(int left, int top, int right, int bottom) {
        this.internalSetInset(left, top, right, bottom);
    }

    private final void internalSetInset(int left, int top, int right, int bottom) {
        boolean changed = false;
        if (this.insetStart != left) {
            changed = true;
            this.insetStart = left;
        }
        if (this.insetTop != top) {
            changed = true;
            this.insetTop = top;
        }
        if (this.insetEnd != right) {
            changed = true;
            this.insetEnd = right;
        }
        if (this.insetBottom != bottom) {
            changed = true;
            this.insetBottom = bottom;
        }
        if (changed) {
            this.shapeDrawable.setInset(left, top, right, bottom);
            this.requestLayout();
            this.invalidateOutline();
        }
    }

    public final void setShadowElevation(float shadowElevation) {
        this.shapeDrawable.setShadowElevation(shadowElevation);
    }

    public final float getShadowElevation() {
        return this.shapeDrawable.getShadowElevation();
    }

    public final void setShadowColorLight(@ColorInt int shadowColor) {
        this.shapeDrawable.setShadowColorLight(shadowColor);
    }

    public final void setShadowColorDark(@ColorInt int shadowColor) {
        this.shapeDrawable.setShadowColorDark(shadowColor);
    }

    public void setTranslationZ(float translationZ) {
        super.setTranslationZ(translationZ);
        if (this.isInitialized) {
            this.shapeDrawable.setTranslationZ(translationZ);
        }
    }

    @JvmOverloads
    public NeumorphButton(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        NeumorphShapeDrawable neumorphShapeDrawable;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.NeumorphButton, defStyleAttr, defStyleRes);
        Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"context.obtainStyledAttr\u2026tr, defStyleRes\n        )");
        TypedArray a = typedArray;
        ColorStateList fillColor = a.getColorStateList(R.styleable.NeumorphButton_neumorph_backgroundColor);
        ColorStateList strokeColor = a.getColorStateList(R.styleable.NeumorphButton_neumorph_strokeColor);
        float strokeWidth = a.getDimension(R.styleable.NeumorphButton_neumorph_strokeWidth, 0.0f);
        int lightSource = a.getInt(R.styleable.NeumorphButton_neumorph_lightSource, 0);
        int shapeType = a.getInt(R.styleable.NeumorphButton_neumorph_shapeType, 0);
        int inset = a.getDimensionPixelSize(R.styleable.NeumorphButton_neumorph_inset, 0);
        int insetStart = a.getDimensionPixelSize(R.styleable.NeumorphButton_neumorph_insetStart, -1);
        int insetEnd = a.getDimensionPixelSize(R.styleable.NeumorphButton_neumorph_insetEnd, -1);
        int insetTop = a.getDimensionPixelSize(R.styleable.NeumorphButton_neumorph_insetTop, -1);
        int insetBottom = a.getDimensionPixelSize(R.styleable.NeumorphButton_neumorph_insetBottom, -1);
        float shadowElevation = a.getDimension(R.styleable.NeumorphButton_neumorph_shadowElevation, 0.0f);
        int shadowColorLight = NeumorphResources.INSTANCE.getColor(context, a, R.styleable.NeumorphButton_neumorph_shadowColorLight, R.color.design_default_color_shadow_light);
        int shadowColorDark = NeumorphResources.INSTANCE.getColor(context, a, R.styleable.NeumorphButton_neumorph_shadowColorDark, R.color.design_default_color_shadow_dark);
        a.recycle();
        NeumorphShapeDrawable neumorphShapeDrawable2 = new NeumorphShapeDrawable(context, attrs, defStyleAttr, defStyleRes);
        NeumorphButton neumorphButton = this;
        boolean bl = false;
        boolean bl2 = false;
        NeumorphShapeDrawable $this$apply = neumorphShapeDrawable2;
        boolean bl3 = false;
        $this$apply.setInEditMode(this.isInEditMode());
        $this$apply.setLightSource(lightSource);
        $this$apply.setShapeType(shapeType);
        $this$apply.setShadowElevation(shadowElevation);
        $this$apply.setShadowColorLight(shadowColorLight);
        $this$apply.setShadowColorDark(shadowColorDark);
        $this$apply.setFillColor(fillColor);
        $this$apply.setStroke(strokeWidth, strokeColor);
        $this$apply.setTranslationZ(this.getTranslationZ());
        neumorphButton.shapeDrawable = neumorphShapeDrawable = neumorphShapeDrawable2;
        this.internalSetInset(insetStart >= 0 ? insetStart : inset, insetTop >= 0 ? insetTop : inset, insetEnd >= 0 ? insetEnd : inset, insetBottom >= 0 ? insetBottom : inset);
        this.setBackgroundInternal(this.shapeDrawable);
        this.isInitialized = true;
    }

    public /* synthetic */ NeumorphButton(Context context, AttributeSet attributeSet, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            attributeSet = null;
        }
        if ((n3 & 4) != 0) {
            n = R.attr.neumorphButtonStyle;
        }
        if ((n3 & 8) != 0) {
            n2 = R.style.Widget_Neumorph_Button;
        }
        this(context, attributeSet, n, n2);
    }

    @JvmOverloads
    public NeumorphButton(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0, 8, null);
    }

    @JvmOverloads
    public NeumorphButton(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 0, 12, null);
    }

    @JvmOverloads
    public NeumorphButton(@NotNull Context context) {
        this(context, null, 0, 0, 14, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lsoup/neumorphism/NeumorphButton$Companion;", "", "()V", "LOG_TAG", "", "neumorphism_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

