/*
 * Decompiled with CFR 0.152.
 */
package com.forjrking.lubankt;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import com.forjrking.lubankt.Checker;
import com.forjrking.lubankt.io.BufferedInputStreamWrap;
import com.forjrking.lubankt.parser.ImageType;
import com.forjrking.lubankt.parser.ImgHeaderParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c1\u0002\u0018\u00002\u00020\u0001:\u0002./B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u000bJ\u0010\u0010\u001d\u001a\u00020\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u001e\u0010 \u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0010\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0002J\u0010\u0010&\u001a\u00020'2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u001e\u0010(\u001a\u00020'2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010!\u001a\u00020)H\u0002J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000bJ\b\u0010-\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00060"}, d2={"Lcom/forjrking/lubankt/Checker;", "", "()V", "DEFAULT_HEIGHT_QUALITY", "", "DEFAULT_LOW_QUALITY", "DEFAULT_QUALITY", "DEFAULT_XX_HEIGHT_QUALITY", "DEFAULT_X_HEIGHT_QUALITY", "MARK_READ_LIMIT", "TAG", "", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "setContext", "(Landroid/content/Context;)V", "parsers", "", "Lcom/forjrking/lubankt/parser/ImgHeaderParser;", "getParsers", "()Ljava/util/List;", "parsers$delegate", "Lkotlin/Lazy;", "calculateQuality", "getCacheDir", "Ljava/io/File;", "cacheName", "getOrientation", "stream", "Ljava/io/InputStream;", "getOrientationInternal", "reader", "Lcom/forjrking/lubankt/Checker$OrientationReader;", "getRotateDegree", "getRotateDegreeFromOrientation", "orientation", "getType", "Lcom/forjrking/lubankt/parser/ImageType;", "getTypeInternal", "Lcom/forjrking/lubankt/Checker$TypeReader;", "logger", "", "log", "reflectContext", "OrientationReader", "TypeReader", "library_release"})
@SuppressLint(value={"StaticFieldLeak"})
public final class Checker {
    private static final Lazy parsers$delegate;
    @NotNull
    public static final String TAG = "Luban";
    private static final int DEFAULT_QUALITY = 66;
    private static final int DEFAULT_LOW_QUALITY = 60;
    private static final int DEFAULT_HEIGHT_QUALITY = 82;
    private static final int DEFAULT_X_HEIGHT_QUALITY = 88;
    private static final int DEFAULT_XX_HEIGHT_QUALITY = 94;
    public static final int MARK_READ_LIMIT = 0x500000;
    public static Context context;
    @NotNull
    public static final Checker INSTANCE;

    private final List<ImgHeaderParser> getParsers() {
        Lazy lazy = parsers$delegate;
        Checker checker = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    public final int calculateQuality(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DisplayMetrics dm = new DisplayMetrics();
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        ((WindowManager)object).getDefaultDisplay().getMetrics(dm);
        float density = dm.density;
        return density > 3.0f ? 60 : (density > 2.5f && density <= 3.0f ? 66 : (density > 2.0f && density <= 2.5f ? 82 : (density > 1.5f && density <= 2.0f ? 88 : 94)));
    }

    @Nullable
    public final File getCacheDir(@NotNull Context context, @NotNull String cacheName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cacheName, (String)"cacheName");
        File cacheDir = context.getExternalCacheDir();
        if (cacheDir != null) {
            File result2 = new File(cacheDir, cacheName);
            return !result2.mkdirs() && (!result2.exists() || !result2.isDirectory()) ? null : result2;
        }
        return null;
    }

    @NotNull
    public final ImageType getType(@Nullable InputStream stream) throws IOException {
        InputStream inputStream = stream;
        if (inputStream == null) {
            return ImageType.UNKNOWN;
        }
        InputStream inputStream2 = inputStream;
        if (!inputStream2.markSupported()) {
            inputStream2 = new BufferedInputStreamWrap(inputStream2);
        }
        inputStream2.mark(0x500000);
        InputStream finalIs = inputStream2;
        TypeReader reader2 = new TypeReader(finalIs){
            final /* synthetic */ InputStream $finalIs;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public ImageType getType(@NotNull ImgHeaderParser parser) {
                ImageType imageType;
                Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
                try {
                    imageType = parser.getType(this.$finalIs);
                }
                finally {
                    this.$finalIs.reset();
                }
                return imageType;
            }
            {
                this.$finalIs = $captured_local_variable$0;
            }
        };
        return this.getTypeInternal(this.getParsers(), reader2);
    }

    private final ImageType getTypeInternal(List<? extends ImgHeaderParser> parsers2, TypeReader reader2) throws IOException {
        Iterable $this$forEach$iv = parsers2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ImgHeaderParser parser = (ImgHeaderParser)element$iv;
            boolean bl = false;
            ImageType type = reader2.getType(parser);
            if (type == ImageType.UNKNOWN) continue;
            return type;
        }
        return ImageType.UNKNOWN;
    }

    public final int getOrientation(@Nullable InputStream stream) throws IOException {
        InputStream inputStream = stream;
        if (inputStream == null) {
            return -1;
        }
        InputStream inputStream2 = inputStream;
        if (!inputStream2.markSupported()) {
            inputStream2 = new BufferedInputStreamWrap(inputStream2);
        }
        inputStream2.mark(0x500000);
        InputStream finalIs = inputStream2;
        OrientationReader reader2 = new OrientationReader(finalIs){
            final /* synthetic */ InputStream $finalIs;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int getOrientation(@NotNull ImgHeaderParser parser) {
                int n;
                Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
                try {
                    n = parser.getOrientation(this.$finalIs);
                }
                finally {
                    this.$finalIs.reset();
                }
                return n;
            }
            {
                this.$finalIs = $captured_local_variable$0;
            }
        };
        return this.getOrientationInternal(this.getParsers(), reader2);
    }

    private final int getOrientationInternal(List<? extends ImgHeaderParser> parsers2, OrientationReader reader2) throws IOException {
        Iterable $this$forEach$iv = parsers2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ImgHeaderParser parser = (ImgHeaderParser)element$iv;
            boolean bl = false;
            int orientation = reader2.getOrientation(parser);
            if (orientation == -1) continue;
            return orientation;
        }
        return -1;
    }

    public final int getRotateDegree(@Nullable InputStream stream) throws IOException {
        return this.getRotateDegreeFromOrientation(this.getOrientation(stream));
    }

    private final int getRotateDegreeFromOrientation(int orientation) {
        int n;
        switch (orientation) {
            case 5: 
            case 6: {
                n = 90;
                break;
            }
            case 3: 
            case 4: {
                n = 180;
                break;
            }
            case 7: 
            case 8: {
                n = 270;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @NotNull
    public final Context getContext() {
        Context context = Checker.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        return context;
    }

    public final void setContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        Checker.context = context;
    }

    private final Context reflectContext() {
        try {
            Object object = Class.forName("android.app.ActivityThread").getMethod("currentApplication", new Class[0]).invoke(null, new Object[0]);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.Application");
            }
            return (Context)((Application)object);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                Object object = Class.forName("android.app.AppGlobals").getMethod("getInitialApplication", new Class[0]).invoke(null, new Object[0]);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.app.Application");
                }
                return (Context)((Application)object);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw (Throwable)new IllegalStateException("reflect Context error,\u9ad8\u7248\u672c\u5e9f\u5f03\u53cd\u5c04\u540e\u5efa\u8bae\u81ea\u5df1\u8d4b\u503c");
            }
        }
    }

    public final void logger(@NotNull String log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Log.d((String)TAG, (String)log);
    }

    private Checker() {
    }

    static {
        Checker checker;
        INSTANCE = checker = new Checker();
        parsers$delegate = LazyKt.lazy((Function0)parsers.2.INSTANCE);
        try {
            context = checker.reflectContext();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/forjrking/lubankt/Checker$TypeReader;", "", "getType", "Lcom/forjrking/lubankt/parser/ImageType;", "parser", "Lcom/forjrking/lubankt/parser/ImgHeaderParser;", "library_release"})
    private static interface TypeReader {
        @NotNull
        public ImageType getType(@NotNull ImgHeaderParser var1) throws IOException;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/forjrking/lubankt/Checker$OrientationReader;", "", "getOrientation", "", "parser", "Lcom/forjrking/lubankt/parser/ImgHeaderParser;", "library_release"})
    private static interface OrientationReader {
        public int getOrientation(@NotNull ImgHeaderParser var1) throws IOException;
    }
}

