/*
 * Decompiled with CFR 0.152.
 */
package com.github.fommil.netlib.generator;

import com.github.fommil.netlib.generator.AbstractJavaGenerator;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.stringtemplate.v4.ST;

@Mojo(name="f2j", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class F2jImplGenerator
extends AbstractJavaGenerator {
    @Parameter(required=true)
    protected String implementing;

    @Override
    protected String generate(List<Method> methods) throws Exception {
        ArrayList members = Lists.newArrayList();
        for (Method method : methods) {
            members.add(this.renderMethod(method, false));
            if (!this.hasOffsets(method)) continue;
            members.add(this.renderMethod(method, true));
        }
        ST t = this.jTemplates.getInstanceOf("implClass");
        t.add("package", (Object)this.getTargetPackage());
        t.add("name", (Object)this.getTargetClassName());
        t.add("members", (Object)members);
        t.add("docs", (Object)this.getGenerationSummaryJavadocs());
        t.add("parent", (Object)this.implementing);
        return t.render();
    }

    private String renderMethod(Method method, boolean offsets) {
        ST m = this.jTemplates.getInstanceOf("f2jImplMethod");
        m.add("returns", method.getReturnType());
        m.add("method", (Object)method.getName());
        m.add("paramTypes", this.getNetlibJavaParameterTypes(method, offsets));
        m.add("paramNames", this.getNetlibJavaParameterNames(method, offsets));
        m.add("impl", (Object)(method.getDeclaringClass().getCanonicalName() + "." + method.getName()));
        m.add("calls", this.getF2jJavaParameters(method, offsets));
        if (method.getReturnType().equals(Void.TYPE)) {
            m.add("return", (Object)"");
        }
        return m.render();
    }
}

