/*
 * Decompiled with CFR 0.152.
 */
package io.fno.grel;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;

public class StringFunctions {
    private static final String ALLOWED_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()";

    public static Integer length(String s) {
        return s.length();
    }

    public static Boolean startsWith(String s, String sub) {
        return s.startsWith(sub);
    }

    public static Boolean endsWith(String s, String sub) {
        return s.endsWith(sub);
    }

    public static Boolean contains(String s, String sub) {
        return s.contains(sub);
    }

    public static String toLowercase(String s) {
        return s.toLowerCase();
    }

    public static String toUppercase(String s) {
        return s.toUpperCase();
    }

    public static String toTitlecase(String s) {
        return WordUtils.capitalizeFully((String)s);
    }

    public static String trim(String s) {
        return s.trim();
    }

    public static String chomp(String s, String sep) {
        return StringUtils.chomp((String)s, (String)sep);
    }

    public static String substring(String s, Integer from) {
        return s.substring(from);
    }

    public static String substring(String s, Integer from, Integer to) {
        return s.substring(from, to);
    }

    public static Integer lastIndexOf(String s, String sub) {
        return s.lastIndexOf(sub);
    }

    public static List<String> split(String s, String sep) {
        return Arrays.asList(s.split(sep));
    }

    public static String escape(String s, String mode) {
        String lMode;
        switch (lMode = mode.toLowerCase()) {
            case "html": {
                return StringEscapeUtils.escapeHtml((String)s);
            }
            case "xml": {
                return StringEscapeUtils.escapeXml((String)s);
            }
            case "csv": {
                return StringEscapeUtils.escapeCsv((String)s);
            }
            case "url": {
                return StringFunctions.encodeURIComponent(s);
            }
            case "javascript": {
                return StringEscapeUtils.escapeJavaScript((String)s);
            }
        }
        return s;
    }

    public static String md5(String s) {
        return DigestUtils.md5Hex((String)s);
    }

    public static String sha1(String s) {
        return DigestUtils.sha1Hex((String)s);
    }

    private static String encodeURIComponent(String input) {
        if (StringUtils.isEmpty((String)input)) {
            return input;
        }
        int l = input.length();
        StringBuilder o = new StringBuilder(l * 3);
        try {
            for (int i = 0; i < l; ++i) {
                String e = input.substring(i, i + 1);
                if (!ALLOWED_CHARS.contains(e)) {
                    Byte[] b = ArrayUtils.toObject((byte[])e.getBytes("utf-8"));
                    o.append(StringFunctions.getHex(b));
                    continue;
                }
                o.append(e);
            }
            return o.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return input;
        }
    }

    private static String getHex(Byte[] buf) {
        StringBuilder o = new StringBuilder(buf.length * 3);
        Byte[] byteArray = buf;
        int n = byteArray.length;
        for (int i = 0; i < n; ++i) {
            byte b = byteArray[i];
            int n2 = b & 0xFF;
            o.append("%");
            if (n2 < 16) {
                o.append("0");
            }
            o.append(Long.toString(n2, 16).toUpperCase());
        }
        return o.toString();
    }
}

