/*
 * Decompiled with CFR 0.152.
 */
package io.fno.grel;

import io.fno.grel.DateFunctions;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.language.ColognePhonetic;
import org.apache.commons.codec.language.DoubleMetaphone;
import org.apache.commons.codec.language.Metaphone;
import org.apache.commons.codec.language.Soundex;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.WordUtils;

public class StringFunctions {
    private static final String ALLOWED_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()";

    public static Integer length(String s) {
        return s.length();
    }

    public static String toString(Object valueParameter) {
        return StringFunctions.toString(valueParameter, null);
    }

    public static String toString(Object valueParameter, String format) {
        if (valueParameter == null) {
            return "null";
        }
        if (valueParameter instanceof Date) {
            return DateFunctions.toString((Date)valueParameter, format);
        }
        if (format == null) {
            return valueParameter.toString();
        }
        return String.format(format, valueParameter);
    }

    public static Boolean startsWith(String s, String sub) {
        return s.startsWith(sub);
    }

    public static Boolean endsWith(String s, String sub) {
        return s.endsWith(sub);
    }

    public static Boolean contains(String s, String sub) {
        return s.contains(sub);
    }

    public static String toLowercase(String s) {
        return s.toLowerCase();
    }

    public static String toUppercase(String s) {
        return s.toUpperCase();
    }

    public static String toTitlecase(String s) {
        return WordUtils.capitalizeFully((String)s);
    }

    public static String trim(String s) {
        return s.trim();
    }

    public static String strip(String s) {
        return StringFunctions.trim(s);
    }

    public static String chomp(String s, String sep) {
        return StringUtils.removeEnd((String)s, (String)sep);
    }

    public static String substring(String s, Integer from) {
        return s.substring(from);
    }

    public static String substring(String s, Integer from, Integer to) {
        return s.substring(from, to);
    }

    public static String slice(String s, Integer from, Integer to) {
        return StringFunctions.substring(s, from, to);
    }

    public static String slice(String s, Integer from) {
        return StringFunctions.substring(s, from);
    }

    public static String get(String s, Integer from, Integer to) {
        return StringFunctions.substring(s, from, to);
    }

    public static String get(String s, Integer from) {
        return StringFunctions.substring(s, from);
    }

    public static Integer indexOf(String s, String sub) {
        return s.indexOf(sub);
    }

    public static Integer lastIndexOf(String s, String sub) {
        return s.lastIndexOf(sub);
    }

    public static String replace(String s, String find, String replace) {
        if (find.startsWith("/") && find.endsWith("/")) {
            String regex = find.substring(1, find.length() - 1);
            return s.replaceAll(regex, replace);
        }
        return s.replace(find, replace);
    }

    public static String replaceChars(String s, String f, String r) throws Exception {
        if (f.length() != r.length()) {
            throw new Exception("You must provide as many replacement characters as target characters.");
        }
        for (int i = 0; i < f.length(); ++i) {
            char find = f.charAt(i);
            char replace = r.charAt(i);
            s = s.replace(find, replace);
        }
        return s;
    }

    public static String[] match(String s, String p) {
        if (p.length() < 2 || !p.startsWith("/") || !p.endsWith("/")) {
            throw new InvalidParameterException("A regex in GREL must start and end with '/'");
        }
        String pattern = "^" + p.substring(1, p.length() - 1) + "$";
        ArrayList<String> allMatches = new ArrayList<String>();
        Matcher m = Pattern.compile(pattern).matcher(s);
        int nrGroups = m.groupCount();
        if (m.find()) {
            for (int i = 1; i <= nrGroups; ++i) {
                allMatches.add(m.group(i));
            }
            return allMatches.toArray(new String[0]);
        }
        return null;
    }

    public static Number toNumber(Object o) {
        if (o instanceof Number) {
            return (Number)o;
        }
        return new BigDecimal(o.toString());
    }

    public static String[] split(String s, String sep) {
        return s.split(sep);
    }

    public static String[] splitByLengths(String s, int ... numbers) {
        ArrayList<String> output = new ArrayList<String>();
        int i = 0;
        for (int n : numbers) {
            output.add(s.substring(i, i + n));
            i += n;
        }
        return output.toArray(new String[0]);
    }

    public static String[] smartSplit(String s) {
        String sep = StringUtils.countMatches((CharSequence)s, (CharSequence)"\t") < StringUtils.countMatches((CharSequence)s, (CharSequence)",") ? "," : "\t";
        return StringFunctions.smartSplit(s, sep);
    }

    public static String[] smartSplit(String s, String sep) {
        if (sep.startsWith("/") && sep.endsWith("/")) {
            String pattern = sep.substring(1, sep.length() - 1);
            return s.split(pattern);
        }
        return StringUtils.split((String)s, (String)sep);
    }

    public static String[] splitByCharType(String value) {
        return StringUtils.splitByCharacterType((String)value);
    }

    public static String[] _partition(String s, String frag, Boolean omitFragment, Boolean last) {
        ArrayList<String> output = new ArrayList<String>();
        int offset = 0;
        int index = last != false ? s.indexOf(frag) : s.lastIndexOf(frag);
        if (index == -1) {
            return new String[]{s, "", ""};
        }
        output.add(s.substring(0, index));
        if (!omitFragment.booleanValue()) {
            output.add(frag);
            offset += frag.length();
        }
        output.add(s.substring(index + offset));
        return output.toArray(new String[0]);
    }

    public static String[] partition(String s, String frag) {
        return StringFunctions.partition(s, frag, false);
    }

    public static String[] partition(String s, String frag, Boolean omitFragment) {
        return StringFunctions._partition(s, frag, omitFragment, false);
    }

    public static String[] rpartition(String s, String frag) {
        return StringFunctions.rpartition(s, frag, false);
    }

    public static String[] rpartition(String s, String frag, Boolean omitFragment) {
        return StringFunctions._partition(s, frag, omitFragment, true);
    }

    public static String diff(String o1, String o2) {
        return StringUtils.difference((String)o1, (String)o2);
    }

    public static String escape(String s, String mode) {
        String lMode;
        switch (lMode = mode.toLowerCase()) {
            case "html": {
                return StringEscapeUtils.escapeHtml4((String)s);
            }
            case "xml": {
                return StringEscapeUtils.escapeXml11((String)s);
            }
            case "csv": {
                return StringEscapeUtils.escapeCsv((String)s);
            }
            case "url": {
                return StringFunctions.encodeURIComponent(s);
            }
            case "javascript": {
                return StringEscapeUtils.escapeEcmaScript((String)s);
            }
        }
        return s;
    }

    public static String unescape(String valueParameter, String modeParameter) {
        String mode;
        switch (mode = modeParameter.toLowerCase()) {
            case "html": {
                return StringEscapeUtils.unescapeHtml4((String)valueParameter);
            }
            case "xml": {
                return StringEscapeUtils.unescapeXml((String)valueParameter);
            }
            case "csv": {
                return StringEscapeUtils.unescapeCsv((String)valueParameter);
            }
            case "url": {
                return StringFunctions.decodeURIComponent(valueParameter);
            }
            case "javascript": {
                return StringEscapeUtils.unescapeEcmaScript((String)valueParameter);
            }
        }
        return valueParameter;
    }

    public static String md5(Object s) {
        return DigestUtils.md5Hex((String)s.toString());
    }

    public static String sha1(Object s) {
        return DigestUtils.sha1Hex((String)s.toString());
    }

    public static String phonetic(String s, String mode) throws EncoderException {
        Soundex encoder;
        switch (mode) {
            case "doublemetaphone": {
                DoubleMetaphone dEncoder = new DoubleMetaphone();
                dEncoder.setMaxCodeLen(s.length() * 2);
                encoder = dEncoder;
                break;
            }
            case "metaphone": 
            case "metaphone3": {
                Metaphone mEnc = new Metaphone();
                mEnc.setMaxCodeLen(s.length());
                encoder = mEnc;
                break;
            }
            case "soundex": {
                encoder = new Soundex();
                break;
            }
            case "cologne": {
                encoder = new ColognePhonetic();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + mode);
            }
        }
        return encoder.encode((Object)s).toString();
    }

    public static String reinterpret(String s, String encoderTarget, String encoderSource) throws UnsupportedEncodingException {
        byte[] sourceBytes = s.getBytes(encoderSource);
        return new String(sourceBytes, encoderTarget);
    }

    public static int[] unicode(String s) {
        if (s == null) {
            return null;
        }
        int[] output = new int[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            output[i] = s.codePointAt(i);
        }
        return output;
    }

    private static String encodeURIComponent(String input) {
        if (input == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)input)) {
            return input;
        }
        int l = input.length();
        StringBuilder o = new StringBuilder(l * 3);
        for (int i = 0; i < l; ++i) {
            String e = input.substring(i, i + 1);
            if (!ALLOWED_CHARS.contains(e)) {
                Byte[] b = ArrayUtils.toObject((byte[])e.getBytes(StandardCharsets.UTF_8));
                o.append(StringFunctions.getHex(b));
                continue;
            }
            o.append(e);
        }
        return o.toString();
    }

    private static String decodeURIComponent(String encodedURI) {
        StringBuilder buffer = new StringBuilder();
        int sumb = 0;
        int more = -1;
        for (int i = 0; i < encodedURI.length(); ++i) {
            int bytePattern;
            char actualChar = encodedURI.charAt(i);
            switch (actualChar) {
                case '%': {
                    actualChar = encodedURI.charAt(++i);
                    int hb = (Character.isDigit(actualChar) ? actualChar - 48 : 10 + Character.toLowerCase(actualChar) - 97) & 0xF;
                    actualChar = encodedURI.charAt(++i);
                    int lb = (Character.isDigit(actualChar) ? actualChar - 48 : 10 + Character.toLowerCase(actualChar) - 97) & 0xF;
                    bytePattern = hb << 4 | lb;
                    break;
                }
                case '+': {
                    bytePattern = 32;
                    break;
                }
                default: {
                    bytePattern = actualChar;
                }
            }
            if ((bytePattern & 0xC0) == 128) {
                sumb = sumb << 6 | bytePattern & 0x3F;
                if (--more != 0) continue;
                buffer.append((char)sumb);
                continue;
            }
            if ((bytePattern & 0x80) == 0) {
                buffer.append((char)bytePattern);
                continue;
            }
            if ((bytePattern & 0xE0) == 192) {
                sumb = bytePattern & 0x1F;
                more = 1;
                continue;
            }
            if ((bytePattern & 0xF0) == 224) {
                sumb = bytePattern & 0xF;
                more = 2;
                continue;
            }
            if ((bytePattern & 0xF8) == 240) {
                sumb = bytePattern & 7;
                more = 3;
                continue;
            }
            if ((bytePattern & 0xFC) == 248) {
                sumb = bytePattern & 3;
                more = 4;
                continue;
            }
            sumb = bytePattern & 1;
            more = 5;
        }
        return buffer.toString();
    }

    private static String getHex(Byte[] buf) {
        StringBuilder o = new StringBuilder(buf.length * 3);
        Byte[] byteArray = buf;
        int n = byteArray.length;
        for (int i = 0; i < n; ++i) {
            byte b = byteArray[i];
            int n2 = b & 0xFF;
            o.append("%");
            if (n2 < 16) {
                o.append("0");
            }
            o.append(Long.toString(n2, 16).toUpperCase());
        }
        return o.toString();
    }
}

