/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.expansionpanel;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.florent37.expansionpanel.ExpansionLayout;
import com.github.florent37.expansionpanel.R;

public class ExpansionHeader
extends FrameLayout {
    int headerIndicatorId = 0;
    int expansionLayoutId = 0;
    boolean toggleOnClick = true;
    @Nullable
    View headerIndicator;
    @Nullable
    ExpansionLayout expansionLayout;
    @Nullable
    Animator indicatorAnimator;
    private int headerRotationExpanded = 270;
    private int headerRotationCollapsed = 90;
    private boolean expansionLayoutInitialised = false;

    public ExpansionHeader(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public ExpansionHeader(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ExpansionHeader(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(@NonNull Context context, @Nullable AttributeSet attrs) {
        TypedArray a;
        if (attrs != null && (a = context.obtainStyledAttributes(attrs, R.styleable.ExpansionHeader)) != null) {
            this.setHeaderRotationExpanded(a.getInt(R.styleable.ExpansionHeader_expansion_headerIndicatorRotationExpanded, this.headerRotationExpanded));
            this.setHeaderRotationCollapsed(a.getInt(R.styleable.ExpansionHeader_expansion_headerIndicatorRotationCollapsed, this.headerRotationCollapsed));
            this.setHeaderIndicatorId(a.getResourceId(R.styleable.ExpansionHeader_expansion_headerIndicator, this.headerIndicatorId));
            this.setExpansionLayoutId(a.getResourceId(R.styleable.ExpansionHeader_expansion_layout, this.expansionLayoutId));
            this.setToggleOnClick(a.getBoolean(R.styleable.ExpansionHeader_expansion_toggleOnClick, this.toggleOnClick));
            a.recycle();
        }
    }

    public void setHeaderRotationExpanded(int headerRotationExpanded) {
        this.headerRotationExpanded = headerRotationExpanded;
    }

    public void setHeaderRotationCollapsed(int headerRotationCollapsed) {
        this.headerRotationCollapsed = headerRotationCollapsed;
    }

    public boolean isToggleOnClick() {
        return this.toggleOnClick;
    }

    public void setToggleOnClick(boolean toggleOnClick) {
        this.toggleOnClick = toggleOnClick;
    }

    public void setHeaderIndicatorId(int headerIndicatorId) {
        this.headerIndicatorId = headerIndicatorId;
        if (headerIndicatorId != 0) {
            this.headerIndicator = this.findViewById(headerIndicatorId);
            this.setExpansionHeaderIndicator(this.headerIndicator);
        }
    }

    public void setExpansionHeaderIndicator(@Nullable View headerIndicator) {
        this.headerIndicator = headerIndicator;
        if (headerIndicator != null && Build.VERSION.SDK_INT >= 11) {
            headerIndicator.setLayerType(1, null);
        }
        this.setup();
    }

    public void setExpansionLayout(@Nullable ExpansionLayout expansionLayout) {
        this.expansionLayout = expansionLayout;
        this.setup();
    }

    public void setExpansionLayoutId(int expansionLayoutId) {
        View view;
        ViewParent parent;
        this.expansionLayoutId = expansionLayoutId;
        if (expansionLayoutId != 0 && (parent = this.getParent()) instanceof ViewGroup && (view = ((ViewGroup)parent).findViewById(expansionLayoutId)) instanceof ExpansionLayout) {
            this.setExpansionLayout((ExpansionLayout)view);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setHeaderIndicatorId(this.headerIndicatorId);
        this.setExpansionLayoutId(this.expansionLayoutId);
        this.setup();
    }

    private void setup() {
        if (this.expansionLayout != null && !this.expansionLayoutInitialised) {
            this.expansionLayout.addIndicatorListener(new ExpansionLayout.IndicatorListener(){

                @Override
                public void onStartedExpand(ExpansionLayout expansionLayout, boolean willExpand) {
                    ExpansionHeader.this.onExpansionModifyView(willExpand);
                }
            });
            this.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (ExpansionHeader.this.toggleOnClick) {
                        ExpansionHeader.this.expansionLayout.toggle(true);
                    }
                }
            });
            this.initialiseView(this.expansionLayout.isExpanded());
            this.expansionLayoutInitialised = true;
        }
    }

    protected void initialiseView(boolean isExpanded) {
        if (this.headerIndicator != null) {
            this.headerIndicator.setRotation(isExpanded ? (float)this.headerRotationExpanded : (float)this.headerRotationCollapsed);
        }
    }

    protected void onExpansionModifyView(boolean willExpand) {
        this.setSelected(willExpand);
        if (this.headerIndicator != null) {
            if (this.indicatorAnimator != null) {
                this.indicatorAnimator.cancel();
            }
            this.indicatorAnimator = willExpand ? ObjectAnimator.ofFloat((Object)this.headerIndicator, (Property)View.ROTATION, (float[])new float[]{this.headerRotationExpanded}) : ObjectAnimator.ofFloat((Object)this.headerIndicator, (Property)View.ROTATION, (float[])new float[]{this.headerRotationCollapsed});
            this.indicatorAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation, boolean isReverse) {
                    ExpansionHeader.this.indicatorAnimator = null;
                }
            });
            if (this.indicatorAnimator != null) {
                this.indicatorAnimator.start();
            }
        }
    }

    public boolean isExpanded() {
        return this.expansionLayout != null && this.expansionLayout.isExpanded();
    }

    public void addListener(ExpansionLayout.Listener listener) {
        if (this.expansionLayout != null) {
            this.expansionLayout.addListener(listener);
        }
    }

    public void removeListener(ExpansionLayout.Listener listener) {
        if (this.expansionLayout != null) {
            this.expansionLayout.removeListener(listener);
        }
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Bundle savedInstance = new Bundle();
        savedInstance.putParcelable("super", super.onSaveInstanceState());
        savedInstance.putInt("headerIndicatorId", this.headerIndicatorId);
        savedInstance.putInt("expansionLayoutId", this.expansionLayoutId);
        savedInstance.putBoolean("toggleOnClick", this.toggleOnClick);
        savedInstance.putInt("headerRotationExpanded", this.headerRotationExpanded);
        savedInstance.putInt("headerRotationCollapsed", this.headerRotationCollapsed);
        return savedInstance;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle savedInstance = (Bundle)state;
            this.headerIndicatorId = savedInstance.getInt("headerIndicatorId");
            this.expansionLayoutId = savedInstance.getInt("expansionLayoutId");
            this.setToggleOnClick(savedInstance.getBoolean("toggleOnClick"));
            this.setHeaderRotationExpanded(savedInstance.getInt("headerRotationExpanded"));
            this.setHeaderRotationCollapsed(savedInstance.getInt("headerRotationCollapsed"));
            this.expansionLayoutInitialised = false;
            super.onRestoreInstanceState(savedInstance.getParcelable("super"));
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    @Nullable
    public View getHeaderIndicator() {
        return this.headerIndicator;
    }
}

