/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane.webview.jsinterface;

import android.app.Activity;
import android.content.Context;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.flarelane.FlareLane;
import com.flarelane.Logger;
import com.flarelane.util.ExtensionsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0007J\u0012\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0007J\b\u0010\u000f\u001a\u00020\bH\u0007J\u001a\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\nH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/flarelane/webview/jsinterface/FlareLaneJavascriptInterface;", "", "context", "Landroid/content/Context;", "webView", "Landroid/webkit/WebView;", "(Landroid/content/Context;Landroid/webkit/WebView;)V", "openUrl", "", "url", "", "setTags", "jsonString", "setUserId", "userId", "syncDeviceData", "trackEvent", "type", "Companion", "FlareLane_release"})
public final class FlareLaneJavascriptInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final WebView webView;
    @NotNull
    public static final String BRIDGE_NAME = "FlareLaneBridge";

    public FlareLaneJavascriptInterface(@NotNull Context context, @NotNull WebView webView) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        this.context = context;
        this.webView = webView;
    }

    @JavascriptInterface
    public final void syncDeviceData() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"projectId", (Object)FlareLane.getProjectId(this.context)), TuplesKt.to((Object)"platform", (Object)"android"), TuplesKt.to((Object)"deviceId", (Object)FlareLane.getDeviceId(this.context)), TuplesKt.to((Object)"userId", (Object)FlareLane.getUserId(this.context))};
        Map data = MapsKt.mapOf((Pair[])pairArray);
        String string2 = new JSONObject(data).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String jsonString = string2;
        Ref.ObjectRef script = new Ref.ObjectRef();
        script.element = "FlareLane.syncDeviceDataCallback(" + jsonString + ')';
        Logger.verbose("executed syncDeviceData from webView: " + (String)script.element);
        this.webView.post(() -> FlareLaneJavascriptInterface.syncDeviceData$lambda$0(this, script));
    }

    @JavascriptInterface
    public final void setUserId(@Nullable String userId) {
        FlareLane.setUserId(this.context, userId);
    }

    @JavascriptInterface
    public final void setTags(@NotNull String jsonString) {
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        ExtensionsKt.toJSONObject(jsonString, (Function1<? super JSONObject, Unit>)((Function1)new Function1<JSONObject, Unit>(this){
            final /* synthetic */ FlareLaneJavascriptInterface this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull JSONObject it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                FlareLane.setTags(FlareLaneJavascriptInterface.access$getContext$p(this.this$0), it);
            }
        }));
    }

    @JavascriptInterface
    public final void trackEvent(@NotNull String type, @Nullable String jsonString) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ExtensionsKt.toJSONObjectWithNull(jsonString, (Function1<? super JSONObject, Unit>)((Function1)new Function1<JSONObject, Unit>(this, type){
            final /* synthetic */ FlareLaneJavascriptInterface this$0;
            final /* synthetic */ String $type;
            {
                this.this$0 = $receiver;
                this.$type = $type;
                super(1);
            }

            public final void invoke(@Nullable JSONObject it) {
                FlareLane.trackEvent(FlareLaneJavascriptInterface.access$getContext$p(this.this$0), this.$type, it);
            }
        }));
    }

    @JavascriptInterface
    public final void openUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (this.context instanceof Activity) {
            ((Activity)this.context).runOnUiThread(() -> FlareLaneJavascriptInterface.openUrl$lambda$1(this, url));
        }
    }

    private static final void syncDeviceData$lambda$0(FlareLaneJavascriptInterface this$0, Ref.ObjectRef $script) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$script, (String)"$script");
        this$0.webView.evaluateJavascript((String)$script.element, null);
    }

    private static final void openUrl$lambda$1(FlareLaneJavascriptInterface this$0, String $url) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        this$0.webView.loadUrl($url);
    }

    public static final /* synthetic */ Context access$getContext$p(FlareLaneJavascriptInterface $this) {
        return $this.context;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/flarelane/webview/jsinterface/FlareLaneJavascriptInterface$Companion;", "", "()V", "BRIDGE_NAME", "", "FlareLane_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

