/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane;

import com.flarelane.FlareLane;
import com.flarelane.HTTPClient;
import com.flarelane.Notification;
import com.flarelane.Utils;
import org.json.JSONArray;
import org.json.JSONObject;

class EventService {
    static Notification unhandledClickedNotification;

    EventService() {
    }

    protected static void createClicked(String projectId, String deviceId, Notification notification) throws Exception {
        EventService.create(projectId, deviceId, notification.id, "CLICKED");
        if (FlareLane.notificationClickedHandler != null) {
            FlareLane.notificationClickedHandler.onClicked(notification);
        } else {
            unhandledClickedNotification = notification;
        }
    }

    protected static void createBackgroundReceived(String projectId, String deviceId, Notification notification) throws Exception {
        EventService.create(projectId, deviceId, notification.id, "BACKGROUND_RECEIVED");
    }

    protected static void createForegroundReceived(String projectId, String deviceId, Notification notification) throws Exception {
        EventService.create(projectId, deviceId, notification.id, "FOREGROUND_RECEIVED");
    }

    private static void create(String projectId, String deviceId, String notificationId, String type) throws Exception {
        JSONObject body = new JSONObject();
        body.put("notificationId", (Object)notificationId);
        body.put("deviceId", (Object)deviceId);
        body.put("platform", (Object)"android");
        body.put("type", (Object)type);
        body.put("createdAt", (Object)Utils.getISO8601DateString());
        HTTPClient.post("internal/v1/projects/" + projectId + "/events", body, new HTTPClient.ResponseHandler());
    }

    protected static void trackEvent(String projectId, String subjectType, String subjectId, String type, JSONObject data) throws Exception {
        JSONObject event = new JSONObject().put("type", (Object)type).put("subjectType", (Object)subjectType).put("subjectId", (Object)subjectId).put("createdAt", (Object)Utils.getISO8601DateString());
        if (data != null) {
            event.put("data", (Object)data);
        }
        JSONObject body = new JSONObject().put("events", (Object)new JSONArray().put((Object)event));
        HTTPClient.post("internal/v1/projects/" + projectId + "/events-v2", body, new HTTPClient.ResponseHandler());
    }
}

