/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane;

import android.app.Application;
import android.content.Context;
import androidx.annotation.NonNull;
import com.flarelane.ActivityLifecycleManager;
import com.flarelane.BaseErrorHandler;
import com.flarelane.BaseSharedPreferences;
import com.flarelane.ChannelManager;
import com.flarelane.Device;
import com.flarelane.DeviceService;
import com.flarelane.EventService;
import com.flarelane.FirebaseManager;
import com.flarelane.Logger;
import com.flarelane.NotificationConvertedHandler;
import com.flarelane.RemoteParams;
import com.flarelane.RemoteParamsManager;
import com.flarelane.SdkType;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import java.util.ArrayList;
import org.json.JSONObject;

public class FlareLane {
    protected static NotificationConvertedHandler notificationConvertedHandler = null;
    private static ActivityLifecycleManager activityLifecycleManager = new ActivityLifecycleManager();
    protected static int notificationIcon = 0;

    public static void initWithContext(final Context context, final String projectId) {
        try {
            Logger.verbose("initWithContext projectId: " + projectId);
            ChannelManager.createNotificationChannel(context);
            String savedProjectId = BaseSharedPreferences.getProjectId(context, true);
            if (savedProjectId == null || !savedProjectId.contentEquals(projectId)) {
                BaseSharedPreferences.setDeviceId(context, null);
            }
            Application application = (Application)context.getApplicationContext();
            application.registerActivityLifecycleCallbacks(FlareLane.activityLifecycleManager.mActivityLifecycleCallbacks);
            RemoteParamsManager.fetchRemoteParams(projectId, new RemoteParamsManager.ResponseHandler(){

                @Override
                public void onSuccess(RemoteParams remoteParams) {
                    try {
                        if (remoteParams.fcmSenderId == null) {
                            Logger.error("senderId is null. Please check a property of your project");
                            return;
                        }
                        final String savedDeviceId = BaseSharedPreferences.getDeviceId(context, true);
                        final String savedPushToken = BaseSharedPreferences.getPushToken(context, true);
                        Task getTokenTask = FirebaseManager.getFirebaseMessaging(context, remoteParams).getToken();
                        getTokenTask.addOnCompleteListener((OnCompleteListener)new OnCompleteListener<String>(){

                            public void onComplete(@NonNull Task<String> task) {
                                try {
                                    if (!task.isSuccessful()) {
                                        Logger.error("Fetching FCM registration token failed: " + task.getException());
                                        return;
                                    }
                                    String token = (String)task.getResult();
                                    if (token == null) {
                                        Logger.error("token is null");
                                        return;
                                    }
                                    Logger.verbose("FirebaseMessaging.getInstance().getToken() is Completed");
                                    if (savedPushToken == null || !savedPushToken.contentEquals(token)) {
                                        Logger.verbose("new PushToken is saved");
                                        BaseSharedPreferences.setPushToken(context, token);
                                    }
                                    if (savedDeviceId == null || savedDeviceId.trim().isEmpty()) {
                                        Logger.verbose("savedDeviceId is not exists, newly registered");
                                        DeviceService.register(context, projectId, token);
                                    } else {
                                        Logger.verbose("savedDeviceId is exists : " + savedDeviceId);
                                    }
                                }
                                catch (Exception e) {
                                    BaseErrorHandler.handle(e);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        BaseErrorHandler.handle(e);
                    }
                }
            });
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    public static void setNotificationIcon(int notificationIcon) {
        FlareLane.notificationIcon = notificationIcon;
    }

    public static void setLogLevel(int logLevel) {
        try {
            Logger.logLevel = logLevel;
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    public static void setNotificationConvertedHandler(NotificationConvertedHandler notificationConvertedHandler) {
        try {
            FlareLane.notificationConvertedHandler = notificationConvertedHandler;
            if (EventService.unhandledConvertedNotification != null) {
                notificationConvertedHandler.onConverted(EventService.unhandledConvertedNotification);
                EventService.unhandledConvertedNotification = null;
            }
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    public static void setIsSubscribed(Context context, boolean isSubscribed) {
        try {
            String projectId = BaseSharedPreferences.getProjectId(context, false);
            String deviceId = BaseSharedPreferences.getDeviceId(context, false);
            JSONObject data = new JSONObject();
            data.put("isSubscribed", isSubscribed);
            DeviceService.update(projectId, deviceId, data, new DeviceService.ResponseHandler(){

                @Override
                public void onSuccess(Device device) {
                }
            });
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    public static void setUserId(Context context, String userId) {
        try {
            String projectId = BaseSharedPreferences.getProjectId(context, false);
            String deviceId = BaseSharedPreferences.getDeviceId(context, false);
            JSONObject data = new JSONObject();
            data.put("userId", userId == null ? JSONObject.NULL : userId);
            DeviceService.update(projectId, deviceId, data, new DeviceService.ResponseHandler(){

                @Override
                public void onSuccess(Device device) {
                }
            });
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    public static void setTags(Context context, JSONObject tags) {
        try {
            String projectId = BaseSharedPreferences.getProjectId(context, false);
            String deviceId = BaseSharedPreferences.getDeviceId(context, false);
            JSONObject data = new JSONObject();
            data.put("tags", (Object)tags);
            DeviceService.update(projectId, deviceId, data, new DeviceService.ResponseHandler(){

                @Override
                public void onSuccess(Device device) {
                }
            });
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    public static void deleteTags(Context context, ArrayList<String> keys) {
        try {
            String projectId = BaseSharedPreferences.getProjectId(context, false);
            String deviceId = BaseSharedPreferences.getDeviceId(context, false);
            DeviceService.deleteTags(projectId, deviceId, keys);
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    public static String getDeviceId(Context context) {
        try {
            String deviceId = BaseSharedPreferences.getDeviceId(context, true);
            return deviceId;
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
            return null;
        }
    }

    public static class SdkInfo {
        public static SdkType type = SdkType.NATIVE;
        public static String version = "1.0.15";
    }
}

