/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane;

import android.app.ActivityManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.legacy.content.WakefulBroadcastReceiver;
import com.flarelane.BaseErrorHandler;
import com.flarelane.BaseSharedPreferences;
import com.flarelane.ChannelManager;
import com.flarelane.EventService;
import com.flarelane.FlareLane;
import com.flarelane.Logger;
import com.flarelane.Notification;
import com.flarelane.NotificationConvertedActivity;
import com.flarelane.NotificationManager;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class FCMBroadcastReceiver
extends WakefulBroadcastReceiver {
    public void onReceive(final Context context, final Intent intent) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FCMBroadcastReceiver.this.showNotification(context, intent);
                }
                catch (Exception e) {
                    BaseErrorHandler.handle(e);
                }
            }
        }).start();
    }

    private void showNotification(Context context, Intent intent) throws Exception {
        if (intent == null || intent.getExtras() == null) {
            Logger.error("intent is NULL");
            return;
        }
        JSONObject jsonObject = this.bundleAsJSONObject(intent.getExtras());
        if (jsonObject == null) {
            Logger.error("jsonObject is NULL");
            return;
        }
        String isFlareLane = jsonObject.optString("isFlareLane");
        if (isFlareLane == null || !isFlareLane.contentEquals("true")) {
            Logger.verbose("It is not a message of FlareLane");
            return;
        }
        Notification flarelaneNotification = new Notification(jsonObject);
        Logger.verbose("Message data payload: " + flarelaneNotification.toString());
        String projectId = BaseSharedPreferences.getProjectId(context, false);
        String deviceId = BaseSharedPreferences.getDeviceId(context, false);
        boolean isForeground = FCMBroadcastReceiver.appInForeground(context);
        Logger.verbose("onMessageReceived isForeground: " + isForeground);
        if (isForeground) {
            EventService.createForegroundReceived(projectId, deviceId, flarelaneNotification);
        } else {
            EventService.createBackgroundReceived(projectId, deviceId, flarelaneNotification);
        }
        Intent convertedIntent = new Intent(context, NotificationConvertedActivity.class).addFlags(0x24000000).putExtra("title", flarelaneNotification.title).putExtra("body", flarelaneNotification.body).putExtra("url", flarelaneNotification.url).putExtra("imageUrl", flarelaneNotification.imageUrl).putExtra("data", flarelaneNotification.data).putExtra("notificationId", flarelaneNotification.id);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)context, (int)new Random().nextInt(543254), (Intent)convertedIntent, (int)0x4000000);
        int currentIcon = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).icon;
        Bitmap image = null;
        if (flarelaneNotification.imageUrl != null) {
            try {
                URL url = new URL(flarelaneNotification.imageUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setDoInput(true);
                connection.connect();
                InputStream in = connection.getInputStream();
                image = BitmapFactory.decodeStream((InputStream)in);
            }
            catch (Exception e) {
                Logger.error(Log.getStackTraceString((Throwable)e));
            }
        }
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, ChannelManager.getDefaultChannelId()).setSmallIcon(this.getNotificationIcon(context)).setContentText((CharSequence)flarelaneNotification.body).setContentTitle((CharSequence)(flarelaneNotification.title == null ? context.getApplicationInfo().loadLabel(context.getPackageManager()).toString() : flarelaneNotification.title)).setAutoCancel(true).setContentIntent(contentIntent).setPriority(2).setVisibility(1);
        if (NotificationManager.accentColor != null) {
            try {
                builder = builder.setColor(Color.parseColor((String)NotificationManager.accentColor));
            }
            catch (Exception e) {
                BaseErrorHandler.handle(e);
            }
        }
        builder = image != null ? builder.setLargeIcon(image).setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(image).bigLargeIcon(null).setSummaryText((CharSequence)flarelaneNotification.body)) : builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)flarelaneNotification.body));
        android.app.Notification notification = builder.build();
        notification.defaults |= 1;
        notification.defaults |= 4;
        notification.defaults |= 2;
        NotificationManagerCompat.from((Context)context).notify((int)new Date().getTime(), notification);
    }

    private static boolean appInForeground(@NonNull Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List runningAppProcesses = activityManager.getRunningAppProcesses();
        if (runningAppProcesses == null) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo runningAppProcess : runningAppProcesses) {
            if (!runningAppProcess.processName.equals(context.getPackageName()) || runningAppProcess.importance != 100) continue;
            return true;
        }
        return false;
    }

    private int getNotificationIcon(Context context) {
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                if (FlareLane.notificationIcon != 0) {
                    return FlareLane.notificationIcon;
                }
                String defaultIconIdentifierName = "ic_stat_flarelane_default";
                int getDefaultIconId = context.getResources().getIdentifier(defaultIconIdentifierName, "drawable", context.getPackageName());
                if (getDefaultIconId != 0) {
                    return getDefaultIconId;
                }
            }
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
        return 17301569;
    }

    private JSONObject bundleAsJSONObject(Bundle bundle) {
        JSONObject json = new JSONObject();
        Set keys = bundle.keySet();
        for (String key : keys) {
            try {
                json.put(key, bundle.get(key));
            }
            catch (JSONException e) {
                Logger.error(Log.getStackTraceString((Throwable)e));
            }
        }
        return json;
    }
}

