/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.flarelane.BaseErrorHandler;
import com.flarelane.BaseSharedPreferences;
import com.flarelane.DeviceService;
import com.flarelane.Logger;

class ActivityLifecycleManager {
    private boolean isActivated = false;
    protected Application.ActivityLifecycleCallbacks mActivityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        }

        public void onActivityStarted(@NonNull Activity activity) {
        }

        public void onActivityResumed(@NonNull Activity activity) {
        }

        public void onActivityPaused(@NonNull Activity activity) {
            try {
                if (!ActivityLifecycleManager.this.isActivated) {
                    Context context = activity.getApplicationContext();
                    String projectId = BaseSharedPreferences.getProjectId(context, false);
                    String deviceId = BaseSharedPreferences.getDeviceId(context, false);
                    String pushToken = BaseSharedPreferences.getPushToken(context, false);
                    Logger.verbose("App is activated");
                    ActivityLifecycleManager.this.isActivated = true;
                    DeviceService.activate(activity.getApplicationContext(), projectId, deviceId, pushToken);
                }
            }
            catch (Exception e) {
                BaseErrorHandler.handle(e);
            }
        }

        public void onActivityStopped(@NonNull Activity activity) {
        }

        public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
        }

        public void onActivityDestroyed(@NonNull Activity activity) {
        }
    };

    ActivityLifecycleManager() {
    }
}

