/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.flarelane.BaseErrorHandler;
import com.flarelane.BaseSharedPreferences;
import com.flarelane.EventService;
import com.flarelane.FlareLane;
import com.flarelane.Logger;
import com.flarelane.Notification;

public class NotificationConvertedActivity
extends Activity {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        try {
            super.onCreate(savedInstanceState);
            if (this.getIntent().hasExtra("notificationId")) {
                String notificationId = this.getIntent().getStringExtra("notificationId");
                String projectId = BaseSharedPreferences.getProjectId(this.getApplicationContext());
                String deviceId = BaseSharedPreferences.getProjectId(this.getApplicationContext());
                EventService.create(projectId, deviceId, notificationId, "CONVERTED");
                if (FlareLane.notificationConvertedHandler != null) {
                    Notification notification = new Notification(notificationId, this.getIntent().getStringExtra("body"), this.getIntent().getStringExtra("title"), this.getIntent().getStringExtra("url"));
                    FlareLane.notificationConvertedHandler.onConverted(notification);
                }
                this.startLaunchActivityIfNoHistory();
            }
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
        finally {
            this.finish();
        }
    }

    private void startLaunchActivityIfNoHistory() {
        if (this.isTaskRoot()) {
            Logger.verbose("This is last activity in the stack");
            Intent launchIntent = this.getPackageManager().getLaunchIntentForPackage(this.getPackageName());
            this.startActivity(launchIntent);
        }
    }
}

