/*
 * Decompiled with CFR 0.152.
 */
package com.bambulabs.fdpulltorefresh.progress_bar;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;
import com.bambulabs.fdpulltorefresh.IGRefreshLayout;
import com.bambulabs.fdpulltorefresh.progress_bar.BaseProgressBar;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u0018H\u0002J\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0007J\u0016\u0010\u001e\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007J\u0016\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\rH\u0016J\b\u0010%\u001a\u00020\u0018H\u0016J\b\u0010&\u001a\u00020\u0018H\u0016J\b\u0010'\u001a\u00020\u0018H\u0002R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/bambulabs/fdpulltorefresh/progress_bar/LineProgressBar;", "Lcom/bambulabs/fdpulltorefresh/progress_bar/BaseProgressBar;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "backColor", "backPaint", "Landroid/graphics/Paint;", "borderWidth", "", "frontColor", "isLoaded", "", "left", "loadingPercent", "paint", "progressAnimator", "Landroid/animation/ValueAnimator;", "top", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "resetAnimation", "setBorderWidth", "width", "setColors", "setLeftAndTop", "setParent", "parent", "Lcom/bambulabs/fdpulltorefresh/IGRefreshLayout;", "setPercent", "percent", "start", "stop", "stopAnimation", "fdpulltorefresh_release"})
public final class LineProgressBar
extends BaseProgressBar {
    private final Paint paint;
    private int backColor;
    private int frontColor;
    private final Paint backPaint;
    private float borderWidth;
    private float left;
    private float top;
    private boolean isLoaded;
    private ValueAnimator progressAnimator;
    private float loadingPercent;
    private HashMap _$_findViewCache;

    public final void setLeftAndTop(int left, int top) {
        this.left = this.dp2px(left);
        this.top = this.dp2px(top);
    }

    public final void setBorderWidth(int width) {
        this.paint.setStrokeWidth((float)this.dp2px(width));
        this.backPaint.setStrokeWidth((float)this.dp2px(width));
    }

    public final void setColors(int backColor, int frontColor) {
        this.paint.setColor(frontColor);
        this.backPaint.setColor(backColor);
    }

    protected void onDraw(@Nullable Canvas canvas) {
        block4: {
            float currentPercent;
            block2: {
                float lineWidth;
                block3: {
                    super.onDraw(canvas);
                    this.top = this.getMParent().getDRAG_MAX_DISTANCE() / 2;
                    currentPercent = ((float)this.getWidth() - this.left) * (this.getMPercent() / (float)100);
                    lineWidth = (float)this.getWidth() - this.left;
                    if (currentPercent <= this.left) {
                        currentPercent = this.left;
                    }
                    Canvas canvas2 = canvas;
                    if (canvas2 != null) {
                        canvas2.drawLine(this.left, this.top, lineWidth, this.top, this.backPaint);
                    }
                    if (!this.isLoading()) break block2;
                    if (!this.isLoaded) break block3;
                    Canvas canvas3 = canvas;
                    if (canvas3 == null) break block4;
                    canvas3.drawLine(this.left, this.top, this.loadingPercent, this.top, this.paint);
                    break block4;
                }
                Canvas canvas4 = canvas;
                if (canvas4 == null) break block4;
                canvas4.drawLine(this.loadingPercent, this.top, lineWidth, this.top, this.paint);
                break block4;
            }
            Canvas canvas5 = canvas;
            if (canvas5 == null) break block4;
            canvas5.drawLine(this.left, this.top, currentPercent, this.top, this.paint);
        }
    }

    @Override
    public void setPercent(float percent) {
        this.setMPercent(percent >= 100.0f ? 100.0f : percent);
        this.invalidate();
    }

    @Override
    public void setParent(@NotNull IGRefreshLayout parent) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)parent), (String)"parent");
        this.setMParent(parent);
    }

    @Override
    public void start() {
        this.setLoading(true);
        this.setMPercent(0.0f);
        this.resetAnimation();
    }

    @Override
    public void stop() {
        this.setMPercent(0.0f);
        this.stopAnimation();
    }

    private final void resetAnimation() {
        block8: {
            if (this.progressAnimator != null) {
                ValueAnimator valueAnimator = this.progressAnimator;
                if (valueAnimator == null) {
                    Intrinsics.throwNpe();
                }
                if (valueAnimator.isRunning()) {
                    ValueAnimator valueAnimator2 = this.progressAnimator;
                    if (valueAnimator2 != null) {
                        valueAnimator2.cancel();
                    }
                }
            }
            ValueAnimator valueAnimator = this.progressAnimator = ValueAnimator.ofFloat((float[])new float[]{this.left, this.getWidth()});
            if (valueAnimator != null) {
                valueAnimator.setDuration(500L);
            }
            ValueAnimator valueAnimator3 = this.progressAnimator;
            if (valueAnimator3 != null) {
                valueAnimator3.setInterpolator((TimeInterpolator)new LinearInterpolator());
            }
            ValueAnimator valueAnimator4 = this.progressAnimator;
            if (valueAnimator4 != null) {
                valueAnimator4.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
                    final /* synthetic */ LineProgressBar this$0;

                    public final void onAnimationUpdate(ValueAnimator it) {
                        ValueAnimator valueAnimator = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"it");
                        Object object = valueAnimator.getAnimatedValue();
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                        }
                        LineProgressBar.access$setLoadingPercent$p(this.this$0, ((Float)object).floatValue());
                        this.this$0.invalidate();
                    }
                    {
                        this.this$0 = lineProgressBar;
                    }
                });
            }
            ValueAnimator valueAnimator5 = this.progressAnimator;
            if (valueAnimator5 != null) {
                valueAnimator5.start();
            }
            ValueAnimator valueAnimator6 = this.progressAnimator;
            if (valueAnimator6 == null) break block8;
            valueAnimator6.addListener(new Animator.AnimatorListener(this){
                final /* synthetic */ LineProgressBar this$0;

                public void onAnimationRepeat(@Nullable Animator p0) {
                }

                public void onAnimationEnd(@Nullable Animator p0) {
                    LineProgressBar.access$setLoaded$p(this.this$0, !LineProgressBar.access$isLoaded$p(this.this$0));
                    LineProgressBar.access$resetAnimation(this.this$0);
                }

                public void onAnimationCancel(@Nullable Animator p0) {
                }

                public void onAnimationStart(@Nullable Animator p0) {
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
    }

    private final void stopAnimation() {
        this.setLoading(false);
        this.isLoaded = false;
        if (this.progressAnimator != null) {
            ValueAnimator valueAnimator = this.progressAnimator;
            if (valueAnimator != null) {
                valueAnimator.cancel();
            }
            ValueAnimator valueAnimator2 = this.progressAnimator;
            if (valueAnimator2 != null) {
                valueAnimator2.removeAllListeners();
            }
            this.progressAnimator = null;
        }
    }

    @JvmOverloads
    public LineProgressBar(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.paint = new Paint(1);
        this.backColor = -3355444;
        this.frontColor = -7829368;
        this.backPaint = new Paint(1);
        this.borderWidth = this.dp2px(4);
        this.left = this.dp2px(10);
        this.top = this.dp2px(60);
        this.paint.setColor(this.frontColor);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(this.borderWidth);
        this.backPaint.setColor(this.backColor);
        this.backPaint.setStyle(Paint.Style.STROKE);
        this.backPaint.setStrokeWidth(this.borderWidth);
    }

    public /* synthetic */ LineProgressBar(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public LineProgressBar(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public LineProgressBar(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ float access$getLoadingPercent$p(LineProgressBar $this) {
        return $this.loadingPercent;
    }

    public static final /* synthetic */ void access$setLoadingPercent$p(LineProgressBar $this, float f) {
        $this.loadingPercent = f;
    }

    public static final /* synthetic */ boolean access$isLoaded$p(LineProgressBar $this) {
        return $this.isLoaded;
    }

    public static final /* synthetic */ void access$setLoaded$p(LineProgressBar $this, boolean bl) {
        $this.isLoaded = bl;
    }

    public static final /* synthetic */ void access$resetAnimation(LineProgressBar $this) {
        $this.resetAnimation();
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

