/*
 * Decompiled with CFR 0.152.
 */
package com.github.fgiannesini.libsass.gradle.plugin.installer;

import com.github.fgiannesini.libsass.gradle.plugin.installer.FrameworkPropertiesEnum;
import com.github.fgiannesini.libsass.gradle.plugin.installer.jruby.JRubyCaller;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.gradle.api.logging.Logger;

public class ScssFrameworkInstaller {
    private String versionToDownload;
    private Path installationPath;
    protected final Logger logger;

    public ScssFrameworkInstaller(Logger logger) {
        this.logger = logger;
    }

    public void installFramework(FrameworkPropertiesEnum frameworkProperties) throws Exception {
        File folder = this.downloadSources(frameworkProperties);
        this.installSources(frameworkProperties, folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installSources(FrameworkPropertiesEnum frameworkProperties, File folder) throws Exception {
        try {
            File sourcesFolder = this.getSourcesFolder(frameworkProperties, folder);
            Path installationPath = this.getInstallationPath(frameworkProperties.getFolderInstallationName());
            this.copySourcesToInstallationPath(sourcesFolder, installationPath);
        }
        finally {
            FileUtils.deleteDirectory((File)folder);
        }
    }

    private File downloadSources(FrameworkPropertiesEnum frameworkProperties) throws IOException {
        JRubyCaller jrubyCaller = new JRubyCaller(this.logger);
        File folder = jrubyCaller.unpack(frameworkProperties.getGemName(), this.versionToDownload);
        return folder;
    }

    protected void copySourcesToInstallationPath(File sourcesFolder, Path installationPath) throws IOException {
        File[] listFiles = sourcesFolder.listFiles();
        if (listFiles == null || listFiles.length == 0) {
            this.logger.error("No files in folder " + sourcesFolder.getAbsolutePath());
            return;
        }
        for (File source : listFiles) {
            if (source.isDirectory()) {
                FileUtils.copyDirectory((File)source, (File)installationPath.resolve(source.getName()).toFile());
                this.logger.info("Folder " + source.getName() + " copied");
                continue;
            }
            FileUtils.copyFile((File)source, (File)installationPath.resolve(source.getName()).toFile());
            this.logger.info("File " + source.getName() + " copied");
        }
    }

    protected Path getInstallationPath(String folderInstallationName) throws IOException {
        if (this.installationPath == null) {
            throw new IOException("Installation path is a mandatory parameter, please set it");
        }
        Path installPath = this.installationPath.resolve(folderInstallationName);
        FileUtils.forceMkdir((File)installPath.toFile());
        this.logger.info("Install folder : " + installPath);
        return installPath;
    }

    protected File getSourcesFolder(FrameworkPropertiesEnum frameworkProperties, File folder) throws Exception {
        File unpackedSourceFolder = this.getAndCheckUnpackedSourceFolder(frameworkProperties.getGemName(), folder);
        File sourcesFolder = Paths.get(unpackedSourceFolder.getAbsolutePath(), new String[0]).resolve(frameworkProperties.getInternalGemSourcesPath()).toFile();
        this.logger.info((Object)((Object)frameworkProperties) + " sources folder : " + sourcesFolder.getAbsolutePath());
        return sourcesFolder;
    }

    protected File getAndCheckUnpackedSourceFolder(String gemName, File folder) throws Exception {
        File[] unpackedFiles = folder.listFiles();
        if (unpackedFiles == null || unpackedFiles.length == 0) {
            this.logger.error("No files in folder " + folder.getAbsolutePath());
            throw new Exception("A problem occured while retrieving " + gemName + " sources files");
        }
        if (unpackedFiles.length != 1) {
            this.logger.error("Folder " + folder.getAbsolutePath() + "should contains only one folder. Folder content :");
            Arrays.stream(unpackedFiles).map(File::getName).forEach(arg_0 -> ((Logger)this.logger).error(arg_0));
            throw new Exception("A problem occured while retrieving " + gemName + " sources files");
        }
        return unpackedFiles[0];
    }

    public void setVersionToDownload(String versionToDownload) {
        this.versionToDownload = versionToDownload;
    }

    public void setInstallationPath(Path installationPath) {
        this.installationPath = installationPath;
    }
}

