/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.msgsimple.bundle;

import com.github.fge.Frozen;
import com.github.fge.msgsimple.bundle.MessageBundleBuilder;
import com.github.fge.msgsimple.locale.LocaleUtils;
import com.github.fge.msgsimple.provider.MessageSourceProvider;
import com.github.fge.msgsimple.provider.StaticMessageSourceProvider;
import com.github.fge.msgsimple.source.MessageSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MessageBundle
implements Frozen<MessageBundleBuilder> {
    final List<MessageSourceProvider> providers = new ArrayList<MessageSourceProvider>();

    public static MessageBundleBuilder newBuilder() {
        return new MessageBundleBuilder();
    }

    MessageBundle(MessageBundleBuilder builder) {
        this.providers.addAll(builder.providers);
    }

    @Deprecated
    private MessageBundle(Builder builder) {
        this.providers.addAll(builder.providers);
    }

    public String getMessage(Locale locale, String key) {
        if (key == null) {
            throw new NullPointerException("null keys are not allowed");
        }
        if (locale == null) {
            throw new NullPointerException("null locales are not allowed");
        }
        for (Locale l : LocaleUtils.getApplicable(locale)) {
            for (MessageSourceProvider provider : this.providers) {
                String ret;
                MessageSource source = provider.getMessageSource(l);
                if (source == null || (ret = source.getKey(key)) == null) continue;
                return ret;
            }
        }
        return key;
    }

    public String getMessage(String key) {
        return this.getMessage(Locale.getDefault(), key);
    }

    @Deprecated
    public String getKey(String key) {
        return this.getMessage(key);
    }

    public MessageBundleBuilder thaw() {
        return new MessageBundleBuilder(this);
    }

    @Deprecated
    public Builder copy() {
        return new Builder(this);
    }

    @Deprecated
    public static final class Builder {
        final List<MessageSourceProvider> providers = new ArrayList<MessageSourceProvider>();

        public Builder() {
        }

        private Builder(MessageBundle bundle) {
            this.providers.addAll(bundle.providers);
        }

        public Builder appendProvider(MessageSourceProvider provider) {
            if (provider == null) {
                throw new NullPointerException("cannot append null provider");
            }
            this.providers.add(provider);
            return this;
        }

        public Builder prependProvider(MessageSourceProvider provider) {
            if (provider == null) {
                throw new NullPointerException("cannot prepend null provider");
            }
            this.providers.add(0, provider);
            return this;
        }

        public Builder appendSource(MessageSource source) {
            MessageSourceProvider provider = StaticMessageSourceProvider.withSingleSource(source);
            this.providers.add(provider);
            return this;
        }

        public Builder prependSource(MessageSource source) {
            MessageSourceProvider provider = StaticMessageSourceProvider.withSingleSource(source);
            this.providers.add(0, provider);
            return this;
        }

        public Builder appendSource(Locale locale, MessageSource source) {
            MessageSourceProvider provider = StaticMessageSourceProvider.withSingleSource(locale, source);
            this.providers.add(provider);
            return this;
        }

        public Builder prependSource(Locale locale, MessageSource source) {
            MessageSourceProvider provider = StaticMessageSourceProvider.withSingleSource(locale, source);
            this.providers.add(0, provider);
            return this;
        }

        public MessageBundle build() {
            return new MessageBundle(this);
        }
    }
}

