/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.messages.MessageBundle;
import com.github.fge.jsonschema.messages.ValidationBundles;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.report.ProcessingMessage;
import java.util.EnumSet;

public abstract class AbstractFormatAttribute
implements FormatAttribute {
    private static final MessageBundle BUNDLE = ValidationBundles.FORMAT;
    private final EnumSet<NodeType> supported;
    private final String fmt;

    protected AbstractFormatAttribute(String fmt, NodeType first, NodeType ... other) {
        this.fmt = fmt;
        this.supported = EnumSet.of(first, other);
    }

    @Override
    public final EnumSet<NodeType> supportedTypes() {
        return EnumSet.copyOf(this.supported);
    }

    protected final ProcessingMessage newMsg(FullData data, String key) {
        return data.newMessage().put("domain", "validation").put("keyword", "format").put("attribute", this.fmt).message(BUNDLE.getString(key)).put("value", data.getInstance().getNode());
    }
}

