/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.validator.helpers.DraftV3TypeKeywordValidator;
import com.github.fge.jsonschema.messages.KeywordValidationMessages;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.report.ListProcessingReport;
import com.github.fge.jsonschema.report.LogLevel;
import com.github.fge.jsonschema.report.MessageProvider;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import java.util.Iterator;

public final class DisallowKeywordValidator
extends DraftV3TypeKeywordValidator {
    public DisallowKeywordValidator(JsonNode digested) {
        super("disallow", digested);
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, FullData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        NodeType type = NodeType.getNodeType((JsonNode)instance);
        if (this.types.contains(type)) {
            report.error(this.newMsg(data).message((Object)KeywordValidationMessages.DISALLOWED_TYPE).put("disallowed", (Iterable)this.types).put("found", (Object)type));
            return;
        }
        SchemaTree tree = data.getSchema();
        JsonPointer schemaPointer = tree.getPointer();
        ObjectNode fullReport = FACTORY.objectNode();
        int nrSuccess = 0;
        Iterator i$ = this.schemas.iterator();
        while (i$.hasNext()) {
            int index = (Integer)i$.next();
            ListProcessingReport subReport = new ListProcessingReport(report.getLogLevel(), LogLevel.FATAL);
            JsonPointer ptr = schemaPointer.append(JsonPointer.of((Object)this.keyword, (Object[])new Object[]{index}));
            FullData newData = data.withSchema(tree.setPointer(ptr));
            processor.process((ProcessingReport)subReport, (MessageProvider)newData);
            fullReport.put(ptr.toString(), subReport.asJson());
            if (!subReport.isSuccess()) continue;
            ++nrSuccess;
        }
        if (nrSuccess != 0) {
            report.error(this.newMsg(data).message((Object)KeywordValidationMessages.DISALLOW_SCHEMA).put("reports", (JsonNode)fullReport));
        }
    }
}

