/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.main.cli;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import joptsimple.HelpFormatter;
import joptsimple.OptionDescriptor;

final class CustomHelpFormatter
implements HelpFormatter {
    private static final String HELP_PREAMBLE = "Syntax: java -jar jsonschema.jar [options] file [file...]";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final Joiner JOINER = Joiner.on((String)LINE_SEPARATOR);
    static final Joiner OPTIONS_JOINER = Joiner.on((String)", ");
    private final List<String> lines = Lists.newArrayList();

    CustomHelpFormatter() {
    }

    public String format(Map<String, ? extends OptionDescriptor> options) {
        LinkedHashSet<? extends OptionDescriptor> opts = new LinkedHashSet<OptionDescriptor>(options.values());
        this.lines.add(HELP_PREAMBLE);
        this.lines.add("");
        this.lines.add("Options: ");
        for (OptionDescriptor optionDescriptor : opts) {
            if (optionDescriptor.representsNonOptions()) continue;
            StringBuilder sb = new StringBuilder().append('\t').append(this.optionsToString(optionDescriptor.options())).append(": ").append(optionDescriptor.description());
            this.lines.add(sb.toString());
        }
        this.lines.add("");
        this.lines.add("Exit codes:");
        this.lines.add("\t0: validation successful;");
        this.lines.add("\t1: exception occurred (appears on stderr)");
        this.lines.add("\t2: command line syntax error (missing argument, etc)");
        this.lines.add("\t100: one or more file(s) failed validation");
        this.lines.add("\t101: one or more schema(s) is/are invalid");
        return JOINER.join(this.lines) + LINE_SEPARATOR;
    }

    private String optionsToString(Collection<String> names) {
        ArrayList list = Lists.newArrayList();
        for (String name : names) {
            list.add((name.length() == 1 ? "-" : "--") + name);
        }
        return OPTIONS_JOINER.join((Iterable)list);
    }
}

