/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.validation;

import com.github.fge.jsonschema.exceptions.InvalidSchemaException;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ProcessorChain;
import com.github.fge.jsonschema.processing.ProcessorSelector;
import com.github.fge.jsonschema.processors.build.ValidatorBuilder;
import com.github.fge.jsonschema.processors.data.FullValidationContext;
import com.github.fge.jsonschema.processors.data.ValidationContext;
import com.github.fge.jsonschema.processors.digest.SchemaDigester;
import com.github.fge.jsonschema.processors.format.FormatProcessor;
import com.github.fge.jsonschema.processors.syntax.SyntaxProcessor;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.google.common.base.Predicate;

public final class ValidationChain
implements Processor<ValidationContext, FullValidationContext> {
    private final Processor<ValidationContext, FullValidationContext> processor;

    public ValidationChain(Library library, boolean useFormat) {
        SyntaxProcessor syntaxProcessor = new SyntaxProcessor(library.getSyntaxCheckers());
        Processor<ValidationContext, FullValidationContext> onSuccess = ValidationChain.mainProcessor(library, useFormat);
        ProcessorSelector<ValidationContext, FullValidationContext> selector = new ProcessorSelector().when(ValidationChain.schemaIsValid()).then(onSuccess).otherwise(ValidationChain.onFailure());
        this.processor = ProcessorChain.startWith(syntaxProcessor).chainWith(selector.getProcessor()).getProcessor();
    }

    public ValidationChain(Library library) {
        this(library, true);
    }

    @Override
    public FullValidationContext process(ProcessingReport report, ValidationContext input) throws ProcessingException {
        return this.processor.process(report, input);
    }

    private static Processor<ValidationContext, FullValidationContext> onFailure() {
        return new Processor<ValidationContext, FullValidationContext>(){

            @Override
            public FullValidationContext process(ProcessingReport report, ValidationContext input) throws ProcessingException {
                ProcessingMessage message = input.newMessage().message(SyntaxMessages.INVALID_SCHEMA);
                throw new InvalidSchemaException(message);
            }
        };
    }

    private static Predicate<ValidationContext> schemaIsValid() {
        return new Predicate<ValidationContext>(){

            public boolean apply(ValidationContext input) {
                return input.getSchema().isValid();
            }
        };
    }

    private static Processor<ValidationContext, FullValidationContext> mainProcessor(Library library, boolean useFormat) {
        SchemaDigester digester = new SchemaDigester(library.getDigesters());
        ValidatorBuilder builder = new ValidatorBuilder(library.getValidators());
        ProcessorChain<ValidationContext, FullValidationContext> chain = ProcessorChain.startWith(digester).chainWith(builder);
        if (useFormat) {
            FormatProcessor formatProcessor = new FormatProcessor(library.getFormatAttributes());
            chain = chain.chainWith(formatProcessor);
        }
        return chain.getProcessor();
    }

    public String toString() {
        return this.processor.toString();
    }
}

