/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.data;

import com.github.fge.jsonschema.report.MessageProvider;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.tree.JsonTree;
import com.github.fge.jsonschema.tree.SchemaTree;

public final class ValidationData
implements MessageProvider {
    private final SchemaTree schema;
    private final JsonTree instance;

    public ValidationData(SchemaTree schema, JsonTree instance) {
        this.schema = schema;
        this.instance = instance;
    }

    public ValidationData(SchemaTree schema) {
        this(schema, null);
    }

    public SchemaTree getSchema() {
        return this.schema;
    }

    public JsonTree getInstance() {
        return this.instance;
    }

    public ValidationData withSchema(SchemaTree schema) {
        return new ValidationData(schema, this.instance);
    }

    public ValidationData withInstance(JsonTree instance) {
        return new ValidationData(this.schema, instance);
    }

    @Override
    public ProcessingMessage newMessage() {
        ProcessingMessage ret = new ProcessingMessage();
        if (this.schema != null) {
            ret.put("schema", this.schema);
        }
        if (this.instance != null) {
            ret.put("instance", this.instance);
        }
        return ret;
    }
}

