/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processing.validation;

import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ProcessorChain;
import com.github.fge.jsonschema.processing.ValidationData;
import com.github.fge.jsonschema.processing.build.FullValidationContext;
import com.github.fge.jsonschema.processing.build.ValidatorBuilder;
import com.github.fge.jsonschema.processing.digest.SchemaDigester;
import com.github.fge.jsonschema.processing.format.FormatProcessor;
import com.github.fge.jsonschema.processing.selector.ProcessorSelector;
import com.github.fge.jsonschema.processing.syntax.SyntaxProcessor;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.google.common.base.Predicate;

public final class ValidationChain
implements Processor<ValidationData, FullValidationContext> {
    private final Processor<ValidationData, FullValidationContext> processor;

    public ValidationChain(Library library) {
        SyntaxProcessor syntaxProcessor = new SyntaxProcessor(library.getSyntaxCheckers());
        SchemaDigester digester = new SchemaDigester(library.getDigesters());
        ValidatorBuilder builder = new ValidatorBuilder(library.getValidators());
        FormatProcessor formatProcessor = new FormatProcessor(library.getFormatAttributes());
        Processor<ValidationData, FullValidationContext> onSuccess = ProcessorChain.startWith(digester).chainWith(builder).chainWith(formatProcessor).end();
        ProcessorSelector<ValidationData, FullValidationContext> selector = new ProcessorSelector().when(ValidationChain.schemaIsValid()).then(onSuccess).otherwise(ValidationChain.onFailure());
        this.processor = ProcessorChain.startWith(syntaxProcessor).chainWith(selector.getProcessor()).end();
    }

    @Override
    public FullValidationContext process(ProcessingReport report, ValidationData input) throws ProcessingException {
        return this.processor.process(report, input);
    }

    private static Processor<ValidationData, FullValidationContext> onFailure() {
        return new Processor<ValidationData, FullValidationContext>(){

            @Override
            public FullValidationContext process(ProcessingReport report, ValidationData input) throws ProcessingException {
                ProcessingMessage message = input.newMessage().msg(SyntaxMessages.INVALID_SCHEMA);
                throw new ProcessingException(message);
            }
        };
    }

    private static Predicate<ValidationData> schemaIsValid() {
        return new Predicate<ValidationData>(){

            public boolean apply(ValidationData input) {
                return input.getSchema().isValid();
            }
        };
    }
}

