/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processing;

import com.github.fge.jsonschema.report.MessageProvider;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.tree.JsonTree2;
import com.github.fge.jsonschema.tree.SchemaTree;

public final class ValidationData
implements MessageProvider {
    private final SchemaTree schema;
    private final JsonTree2 instance;

    public ValidationData(SchemaTree schema, JsonTree2 instance) {
        this.schema = schema;
        this.instance = instance;
    }

    public ValidationData(SchemaTree schema) {
        this(schema, null);
    }

    public SchemaTree getSchema() {
        return this.schema;
    }

    public JsonTree2 getInstance() {
        return this.instance;
    }

    public ValidationData withSchema(SchemaTree schema) {
        return new ValidationData(schema, this.instance);
    }

    public ValidationData withInstance(JsonTree2 instance) {
        return new ValidationData(this.schema, instance);
    }

    @Override
    public ProcessingMessage newMessage() {
        ProcessingMessage ret = new ProcessingMessage();
        if (this.schema != null) {
            ret.put("schema", this.schema);
        }
        if (this.instance != null) {
            ret.put("instance", this.instance);
        }
        return ret;
    }
}

