/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.helpers;

import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.messages.FormatMessages;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.ValidationData;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.net.InetAddresses;

public final class IPv4FormatAttribute
extends AbstractFormatAttribute {
    private static final int IPV4_LENGTH = 4;

    public IPv4FormatAttribute(String fmt) {
        super(fmt, NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void validate(ProcessingReport report, ValidationData data) throws ProcessingException {
        String ipaddr = data.getInstance().getNode().textValue();
        if (InetAddresses.isInetAddress((String)ipaddr) && InetAddresses.forString((String)ipaddr).getAddress().length == 4) {
            return;
        }
        report.error(this.newMsg(data, FormatMessages.INVALID_IPV4_ADDR));
    }
}

