/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.old.keyword.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.old.keyword.PositiveIntegerKeywordValidator;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.validator.ValidationContext;

public final class MaxLengthKeywordValidator
extends PositiveIntegerKeywordValidator {
    public MaxLengthKeywordValidator(JsonNode schema) {
        super("maxLength", schema, NodeType.STRING);
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        int len = instance.textValue().length();
        if (len <= this.intValue) {
            return;
        }
        Message.Builder msg = this.newMsg().addInfo(this.keyword, this.intValue).addInfo("found", len).setMessage("string is too long");
        report.addMessage(msg.build());
    }
}

