/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.SchemaHolder;
import com.github.fge.jsonschema.report.ListProcessingReport;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.AsJson;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class SyntaxProcessor
implements Processor<SchemaHolder, SchemaHolder> {
    private final Map<String, SyntaxChecker> checkers;

    public SyntaxProcessor(Library library) {
        this.checkers = library.getSyntaxCheckers().entries();
    }

    public SyntaxProcessor(Dictionary<SyntaxChecker> dict) {
        this.checkers = dict.entries();
    }

    public SchemaHolder process(ProcessingReport report, SchemaHolder input) throws ProcessingException {
        SchemaTree schema = (SchemaTree)input.getValue();
        ListProcessingReport syntaxReport = new ListProcessingReport(report);
        this.validate((ProcessingReport)syntaxReport, schema);
        report.mergeWith((ProcessingReport)syntaxReport);
        return input;
    }

    private void validate(ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = tree.getNode();
        NodeType type = NodeType.getNodeType((JsonNode)node);
        if (type != NodeType.OBJECT) {
            ProcessingMessage msg = SyntaxProcessor.newMsg(tree).message((Object)SyntaxMessages.NOT_A_SCHEMA).put("found", (Object)type);
            report.error(msg);
            return;
        }
        HashSet fieldNames = Sets.newHashSet((Iterator)node.fieldNames());
        HashSet set = Sets.newHashSet((Iterator)node.fieldNames());
        set.removeAll(this.checkers.keySet());
        if (!set.isEmpty()) {
            report.warn(SyntaxProcessor.newMsg(tree).message((Object)SyntaxMessages.UNKNOWN_KEYWORDS).put("ignored", (Iterable)Ordering.natural().sortedCopy((Iterable)set)));
        }
        ArrayList pointers = Lists.newArrayList();
        TreeMap map = Maps.newTreeMap();
        map.putAll(this.checkers);
        map.keySet().retainAll(fieldNames);
        for (SyntaxChecker checker : map.values()) {
            checker.checkSyntax(pointers, report, tree);
        }
        for (JsonPointer pointer : pointers) {
            this.validate(report, tree.append(pointer));
        }
    }

    private static ProcessingMessage newMsg(SchemaTree tree) {
        return new ProcessingMessage().put("schema", (AsJson)tree).put("domain", "syntax");
    }

    public String toString() {
        return "syntax checker";
    }
}

