/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.messages.KeywordValidationMessages;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public final class PropertiesValidator
extends AbstractKeywordValidator {
    private final Set<String> required;

    public PropertiesValidator(JsonNode digest) {
        super("properties");
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JsonNode element : digest.get("required")) {
            builder.add((Object)element.textValue());
        }
        this.required = builder.build();
    }

    @Override
    public void validate(Processor<FullData, ProcessingReport> processor, ProcessingReport report, FullData data) throws ProcessingException {
        LinkedHashSet set = Sets.newLinkedHashSet(this.required);
        set.removeAll(Sets.newHashSet((Iterator)data.getInstance().getNode().fieldNames()));
        if (!set.isEmpty()) {
            report.error(this.newMsg(data).message((Object)KeywordValidationMessages.MISSING_REQUIRED_MEMBERS).put("required", this.required).put("missing", (Iterable)set));
        }
    }

    @Override
    public String toString() {
        return "required: " + this.required.size() + " properties";
    }
}

