/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.schema.SchemaContext;
import com.github.fge.jsonschema.schema.SchemaNode;
import com.github.fge.jsonschema.validator.JsonValidator;
import com.github.fge.jsonschema.validator.JsonValidatorCache;
import com.google.common.collect.Queues;
import java.util.Deque;

public final class ValidationContext {
    private final JsonValidatorCache cache;
    private final Deque<SchemaContext> contextQueue = Queues.newArrayDeque();
    private SchemaContext currentContext;

    public ValidationContext(JsonValidatorCache cache) {
        this.cache = cache;
    }

    void pushContext(SchemaContext context) {
        this.currentContext = context;
        this.contextQueue.addFirst(context);
    }

    void popContext() {
        this.currentContext = this.contextQueue.removeFirst();
    }

    public FormatAttribute getFormat(String fmt) {
        return this.cache.getFormatAttributes().get(fmt);
    }

    public JsonValidator newValidator(JsonNode node) {
        SchemaNode schemaNode = new SchemaNode(this.currentContext, node);
        return this.cache.getValidator(schemaNode);
    }

    public String toString() {
        return "current: " + this.currentContext;
    }
}

