/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.ref;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.github.fge.jsonschema.main.JsonSchemaException;
import com.github.fge.jsonschema.ref.JsonFragment;
import com.github.fge.jsonschema.report.Domain;
import com.github.fge.jsonschema.report.Message;
import com.google.common.base.CharMatcher;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import java.util.List;

public final class JsonPointer
extends JsonFragment {
    private static final CharMatcher SLASH = CharMatcher.is((char)'/');
    private static final CharMatcher ESCAPE_CHAR = CharMatcher.is((char)'~');
    private static final BiMap<Character, Character> ESCAPE_REPLACEMENT_MAP = new ImmutableBiMap.Builder().put((Object)Character.valueOf('0'), (Object)Character.valueOf('~')).put((Object)Character.valueOf('1'), (Object)Character.valueOf('/')).build();
    private static final CharMatcher ESCAPED = CharMatcher.anyOf((CharSequence)"01");
    private static final CharMatcher SPECIAL = CharMatcher.anyOf((CharSequence)"~/");
    private static final CharMatcher ZERO = CharMatcher.is((char)'0');
    private final List<String> elements;

    public JsonPointer(String input) throws JsonSchemaException {
        super(input);
        ImmutableList.Builder builder = ImmutableList.builder();
        JsonPointer.decode(input, (ImmutableList.Builder<String>)builder);
        this.elements = builder.build();
    }

    private JsonPointer(String fullPointer, List<String> elements) {
        super(fullPointer);
        this.elements = elements;
    }

    public JsonPointer append(String element) {
        ImmutableList newElements = new ImmutableList.Builder().addAll(this.elements).add((Object)element).build();
        return new JsonPointer(this.asString + '/' + JsonPointer.refTokenEncode(element), (List<String>)newElements);
    }

    public JsonPointer append(int index) {
        return this.append(Integer.toString(index));
    }

    @Override
    public JsonNode resolve(JsonNode node) {
        JsonNode ret = node;
        for (String pathElement : this.elements) {
            if (!ret.isContainerNode()) {
                return MissingNode.getInstance();
            }
            if (!(ret = ret.isObject() ? ret.path(pathElement) : ret.path(JsonPointer.arrayIndexFor(pathElement))).isMissingNode()) continue;
            break;
        }
        return ret;
    }

    private static void decode(String input, ImmutableList.Builder<String> builder) throws JsonSchemaException {
        String victim = input;
        while (!victim.isEmpty()) {
            if (!victim.startsWith("/")) {
                Message.Builder msg = JsonPointer.newMsg("reference token not preceeded by '/'");
                throw new JsonSchemaException(msg.build());
            }
            victim = victim.substring(1);
            String cooked = JsonPointer.getNextRefToken(victim);
            victim = victim.substring(cooked.length());
            String raw = JsonPointer.refTokenDecode(cooked);
            builder.add((Object)raw);
        }
    }

    private static String getNextRefToken(String input) throws JsonSchemaException {
        StringBuilder sb = new StringBuilder();
        char[] array = input.toCharArray();
        boolean inEscape = false;
        for (char c : array) {
            if (inEscape) {
                if (!ESCAPED.matches(c)) {
                    Message.Builder msg = JsonPointer.newMsg("bad escape sequence: '~' not followed by a valid token").addInfo("allowed", ESCAPE_REPLACEMENT_MAP.keySet()).addInfo("found", Character.valueOf(c));
                    throw new JsonSchemaException(msg.build());
                }
                sb.append(c);
                inEscape = false;
                continue;
            }
            if (SLASH.matches(c)) break;
            if (ESCAPE_CHAR.matches(c)) {
                inEscape = true;
            }
            sb.append(c);
        }
        if (inEscape) {
            throw new JsonSchemaException(JsonPointer.newMsg("bad escape sequence: '~' not followed by any token").build());
        }
        return sb.toString();
    }

    private static String refTokenDecode(String cooked) {
        StringBuilder sb = new StringBuilder(cooked.length());
        char[] array = cooked.toCharArray();
        boolean inEscape = false;
        for (char c : array) {
            if (ESCAPE_CHAR.matches(c)) {
                inEscape = true;
                continue;
            }
            if (inEscape) {
                sb.append(ESCAPE_REPLACEMENT_MAP.get((Object)Character.valueOf(c)));
                inEscape = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String refTokenEncode(String raw) {
        char[] array;
        StringBuilder sb = new StringBuilder(raw.length());
        for (char c : array = raw.toCharArray()) {
            if (SPECIAL.matches(c)) {
                sb.append('~').append(ESCAPE_REPLACEMENT_MAP.inverse().get((Object)Character.valueOf(c)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static Message.Builder newMsg(String reason) {
        return Domain.REF_RESOLVING.newMessage().setKeyword("$ref").setMessage("illegal JSON Pointer").addInfo("reason", reason);
    }

    private static int arrayIndexFor(String pathElement) {
        if (pathElement.isEmpty()) {
            return -1;
        }
        if (ZERO.matches(pathElement.charAt(0))) {
            return pathElement.length() == 1 ? 0 : -1;
        }
        try {
            return Integer.parseInt(pathElement);
        }
        catch (NumberFormatException ignored) {
            return -1;
        }
    }
}

