/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.net.InternetDomainName;
import org.eel.kitchen.jsonschema.format.FormatAttribute;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class HostnameFormatAttribute
extends FormatAttribute {
    private static final FormatAttribute INSTANCE = new HostnameFormatAttribute();

    private HostnameFormatAttribute() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkValue(String fmt, ValidationReport report, JsonNode value) {
        try {
            InternetDomainName.from((String)value.textValue());
        }
        catch (IllegalArgumentException ignored) {
            Message.Builder msg = HostnameFormatAttribute.newMsg(fmt).setMessage("string is not a valid hostname").addInfo("value", value);
            report.addMessage(msg.build());
        }
    }
}

