/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.report;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.List;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonPointer;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.util.jackson.CustomJsonNodeFactory;

public final class ValidationReport {
    private static final JsonPointer ROOT;
    private static final JsonNodeFactory factory;
    private final ListMultimap<JsonPointer, Message> msgMap = ArrayListMultimap.create();
    private JsonPointer path;
    private boolean fatal = false;

    public ValidationReport() {
        this(ROOT);
    }

    private ValidationReport(JsonPointer path) {
        this.path = path;
    }

    public JsonPointer getPath() {
        return this.path;
    }

    public void setPath(JsonPointer path) {
        this.path = path;
    }

    public boolean addMessage(Message message) {
        if (this.fatal) {
            return true;
        }
        if (message.isFatal()) {
            this.fatal = true;
            this.msgMap.clear();
        }
        this.msgMap.put((Object)this.path, (Object)message);
        return this.fatal;
    }

    public void addMessages(Collection<Message> messages) {
        for (Message message : messages) {
            if (!this.addMessage(message)) continue;
            return;
        }
    }

    public boolean isSuccess() {
        return this.msgMap.isEmpty();
    }

    public boolean hasFatalError() {
        return this.fatal;
    }

    public void mergeWith(ValidationReport other) {
        if (this.fatal) {
            return;
        }
        if (other.fatal) {
            this.msgMap.clear();
            this.fatal = true;
        }
        this.msgMap.putAll(other.msgMap);
    }

    public ValidationReport copy() {
        return new ValidationReport(this.path);
    }

    public List<String> getMessages() {
        List paths = Ordering.natural().sortedCopy((Iterable)this.msgMap.keySet());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JsonPointer pointer : paths) {
            List messages = Ordering.natural().sortedCopy((Iterable)this.msgMap.get((Object)pointer));
            for (Message msg : messages) {
                builder.add((Object)("\"" + pointer + "\": " + msg));
            }
        }
        return builder.build();
    }

    public JsonNode asJsonObject() {
        ObjectNode ret = factory.objectNode();
        for (JsonPointer ptr : this.msgMap.keySet()) {
            ArrayNode node = factory.arrayNode();
            List messages = Ordering.natural().sortedCopy((Iterable)this.msgMap.get((Object)ptr));
            for (Message message : messages) {
                node.add(message.toJsonNode());
            }
            ret.put(ptr.toString(), (JsonNode)node);
        }
        return ret;
    }

    public JsonNode asJsonArray() {
        ArrayNode ret = factory.arrayNode();
        List paths = Ordering.natural().sortedCopy((Iterable)this.msgMap.keySet());
        for (JsonPointer ptr : paths) {
            List messages = Ordering.natural().sortedCopy((Iterable)this.msgMap.get((Object)ptr));
            for (Message msg : messages) {
                ObjectNode node = factory.objectNode().put("path", ptr.toString());
                node.putAll((ObjectNode)msg.toJsonNode());
                ret.add((JsonNode)node);
            }
        }
        return ret;
    }

    public String toString() {
        return "current path: \"" + this.path + "\"; " + this.msgMap.size() + " messages";
    }

    static {
        factory = CustomJsonNodeFactory.getInstance();
        try {
            ROOT = new JsonPointer("");
        }
        catch (JsonSchemaException e) {
            throw new RuntimeException("WTF??", e);
        }
    }
}

