/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.ref;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonRef;
import org.eel.kitchen.jsonschema.ref.SchemaContainer;
import org.eel.kitchen.jsonschema.report.ValidationDomain;
import org.eel.kitchen.jsonschema.report.ValidationMessage;
import org.eel.kitchen.jsonschema.uri.URIManager;

public final class SchemaRegistry {
    private final URI namespace;
    private final LoadingCache<URI, SchemaContainer> cache;

    public SchemaRegistry(final URIManager manager, URI namespace) {
        this.namespace = namespace.normalize();
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<URI, SchemaContainer>(){

            public SchemaContainer load(URI key) throws JsonSchemaException {
                return new SchemaContainer(key, manager.getContent(key));
            }
        });
    }

    public SchemaContainer register(JsonNode schema) {
        Preconditions.checkNotNull((Object)schema, (Object)"cannot register null schema");
        SchemaContainer container = new SchemaContainer(schema);
        JsonRef ref = container.getLocator();
        if (ref.isAbsolute()) {
            this.cache.put((Object)ref.getRootAsURI(), (Object)container);
        }
        return container;
    }

    public SchemaContainer get(URI uri) throws JsonSchemaException {
        URI realURI = this.namespace.resolve(uri).normalize();
        try {
            return (SchemaContainer)this.cache.get((Object)realURI);
        }
        catch (ExecutionException e) {
            ValidationMessage.Builder msg = new ValidationMessage.Builder(ValidationDomain.REF_RESOLVING).setKeyword("N/A").setMessage("failed to get content from URI").addInfo("uri", realURI).addInfo("exception-class", e.getCause().getClass().getName()).addInfo("exception-message", e.getCause().getMessage());
            throw new JsonSchemaException(msg.build());
        }
    }
}

