/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.keyword.AbstractTypeKeywordValidator;
import org.eel.kitchen.jsonschema.report.ValidationMessage;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class TypeKeywordValidator
extends AbstractTypeKeywordValidator {
    public TypeKeywordValidator(JsonNode schema) {
        super("type", schema);
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        NodeType type = NodeType.getNodeType(instance);
        if (this.typeSet.contains((Object)type)) {
            return;
        }
        ValidationReport schemaReport = report.copy();
        if (!this.schemas.isEmpty()) {
            this.trySchemas(context, schemaReport, instance);
            if (schemaReport.isSuccess()) {
                return;
            }
        }
        if (!this.typeSet.isEmpty()) {
            ValidationMessage.Builder msg = this.newMsg().addInfo("found", type).addInfo("allowed", this.typeSet).setMessage("instance does not match any allowed primitive type");
            report.addMessage(msg.build());
        }
        report.mergeWith(schemaReport);
    }

    private void trySchemas(ValidationContext context, ValidationReport schemaReport, JsonNode instance) {
        ValidationReport report = schemaReport.copy();
        for (JsonNode schema : this.schemas) {
            ValidationReport subReport = report.copy();
            JsonValidator validator = context.newValidator(schema);
            validator.validate(context, subReport, instance);
            if (subReport.isSuccess()) {
                return;
            }
            report.mergeWith(subReport);
        }
        schemaReport.mergeWith(report);
    }
}

