/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.report.ValidationMessage;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class EnumKeywordValidator
extends KeywordValidator {
    private final JsonNode enumNode;
    private final Set<JsonNode> enumValues;

    public EnumKeywordValidator(JsonNode schema) {
        super("enum", NodeType.values());
        this.enumNode = schema.get(this.keyword);
        this.enumValues = ImmutableSet.copyOf((Iterable)this.enumNode);
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        if (this.enumValues.contains(instance)) {
            return;
        }
        ValidationMessage.Builder msg = this.newMsg().setMessage("value not found in enum").addInfo("enum", this.enumNode).addInfo("value", instance);
        report.addMessage(msg.build());
    }

    @Override
    public String toString() {
        return this.keyword + ": " + this.enumValues.size() + " possible value(s)";
    }
}

