/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.net.InetAddresses;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.report.ValidationMessage;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class IPV4FormatSpecifier
extends FormatSpecifier {
    private static final FormatSpecifier instance = new IPV4FormatSpecifier();
    private static final int IPV4_LENGTH = 4;

    private IPV4FormatSpecifier() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatSpecifier getInstance() {
        return instance;
    }

    @Override
    public void checkValue(String fmt, ValidationContext ctx, ValidationReport report, JsonNode value) {
        String ipaddr = value.textValue();
        if (InetAddresses.isInetAddress((String)ipaddr) && InetAddresses.forString((String)ipaddr).getAddress().length == 4) {
            return;
        }
        ValidationMessage.Builder msg = IPV4FormatSpecifier.newMsg(fmt).setMessage("string is not a valid IPv4 address").addInfo("value", value);
        report.addMessage(msg.build());
    }
}

