/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.walk;

import com.github.fge.jsonschema.SchemaVersion;
import com.github.fge.jsonschema.exceptions.ExceptionProvider;
import com.github.fge.jsonschema.exceptions.InvalidSchemaException;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.exceptions.SchemaWalkingException;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.load.RefResolver;
import com.github.fge.jsonschema.load.SchemaLoader;
import com.github.fge.jsonschema.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.messages.SchemaWalkerMessages;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ProcessorChain;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.syntax.SyntaxProcessor;
import com.github.fge.jsonschema.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.syntax.dictionaries.DraftV3SyntaxCheckerDictionary;
import com.github.fge.jsonschema.syntax.dictionaries.DraftV4SyntaxCheckerDictionary;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.ValueHolder;
import com.github.fge.jsonschema.util.equivalence.SchemaTreeEquivalence;
import com.github.fge.jsonschema.walk.SchemaListener;
import com.github.fge.jsonschema.walk.SchemaWalker;
import com.github.fge.jsonschema.walk.collectors.PointerCollector;
import com.google.common.base.Equivalence;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;

public final class ResolvingSchemaWalker
extends SchemaWalker {
    private static final ProcessingMessage MESSAGE = new ProcessingMessage().message(SyntaxMessages.INVALID_SCHEMA).setExceptionProvider(new ExceptionProvider(){

        @Override
        public ProcessingException doException(ProcessingMessage message) {
            return new InvalidSchemaException(message);
        }
    });
    private static final Equivalence<SchemaTree> EQUIVALENCE = SchemaTreeEquivalence.getInstance();
    private final Processor<ValueHolder<SchemaTree>, ValueHolder<SchemaTree>> processor;

    public ResolvingSchemaWalker(SchemaTree tree, SchemaVersion version, LoadingConfiguration cfg) {
        super(tree, version);
        Dictionary<SyntaxChecker> checkers = version == SchemaVersion.DRAFTV4 ? DraftV4SyntaxCheckerDictionary.get() : DraftV3SyntaxCheckerDictionary.get();
        RefResolver refResolver = new RefResolver(new SchemaLoader(cfg));
        this.processor = ProcessorChain.startWith(refResolver).chainWith(new SyntaxProcessor(checkers)).failOnError(MESSAGE).getProcessor();
    }

    public ResolvingSchemaWalker(SchemaTree tree, SchemaVersion version) {
        this(tree, version, LoadingConfiguration.byDefault());
    }

    public ResolvingSchemaWalker(SchemaTree tree, Dictionary<PointerCollector> collectors, Dictionary<SyntaxChecker> checkers, LoadingConfiguration cfg) {
        super(tree, collectors);
        RefResolver refResolver = new RefResolver(new SchemaLoader(cfg));
        this.processor = ProcessorChain.startWith(refResolver).chainWith(new SyntaxProcessor(checkers)).failOnError(MESSAGE).getProcessor();
    }

    @Override
    public <T> void resolveTree(SchemaListener<T> listener, ProcessingReport report) throws ProcessingException {
        SchemaTree newTree = this.processor.process(report, ValueHolder.hold("schema", this.tree)).getValue();
        if (EQUIVALENCE.equivalent((Object)this.tree, (Object)newTree)) {
            return;
        }
        ResolvingSchemaWalker.checkTrees(this.tree, newTree);
        listener.onTreeChange(this.tree, newTree);
        this.tree = newTree;
    }

    @Override
    public String toString() {
        return "recursive tree walker ($ref resolution)";
    }

    private static void checkTrees(SchemaTree tree, SchemaTree newTree) throws ProcessingException {
        if (!tree.getLoadingRef().equals(newTree.getLoadingRef())) {
            return;
        }
        JsonPointer sourcePointer = tree.getPointer();
        JsonPointer targetPointer = newTree.getPointer();
        ArrayList sourceTokens = Lists.newArrayList((Iterable)sourcePointer);
        ArrayList targetTokens = Lists.newArrayList((Iterable)targetPointer);
        ProcessingMessage message = new ProcessingMessage().message("").put("schemaURI", tree.getLoadingRef()).put("source", sourcePointer.toString()).put("target", targetPointer.toString());
        if (Collections.indexOfSubList(sourceTokens, targetTokens) == 0) {
            throw new SchemaWalkingException(message.message(SchemaWalkerMessages.PARENT_EXPAND));
        }
        if (Collections.indexOfSubList(targetTokens, sourceTokens) == 0) {
            throw new SchemaWalkingException(message.message(SchemaWalkerMessages.SUBTREE_EXPAND));
        }
    }
}

