/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.syntax.checkers.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.syntax.checkers.helpers.SchemaOrSchemaArraySyntaxChecker;
import com.github.fge.jsonschema.tree.SchemaTree;

public final class DraftV4ItemsSyntaxChecker
extends SchemaOrSchemaArraySyntaxChecker {
    private static final SyntaxChecker INSTANCE = new DraftV4ItemsSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private DraftV4ItemsSyntaxChecker() {
        super("items");
    }

    @Override
    protected void extraChecks(ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree);
        if (node.isArray() && node.size() == 0) {
            report.error(this.newMsg(tree, SyntaxMessages.EMPTY_ARRAY));
        }
    }
}

