/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.syntax.checkers.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.syntax.checkers.helpers.SchemaOrSchemaArraySyntaxChecker;
import com.github.fge.jsonschema.tree.SchemaTree;

public final class ExtendsSyntaxChecker
extends SchemaOrSchemaArraySyntaxChecker {
    private static final SyntaxChecker INSTANCE = new ExtendsSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private ExtendsSyntaxChecker() {
        super("extends");
    }

    @Override
    protected void extraChecks(ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = tree.getNode().get(this.keyword);
        if (node.isArray() && node.size() == 0) {
            report.warn(this.newMsg(tree, SyntaxMessages.EXTENDS_EMPTY_ARRAY));
        }
    }
}

