/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.syntax.checkers.common;

import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.syntax.checkers.helpers.SchemaMapSyntaxChecker;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.RhinoHelper;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;

public final class PatternPropertiesSyntaxChecker
extends SchemaMapSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new PatternPropertiesSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private PatternPropertiesSyntaxChecker() {
        super("patternProperties");
    }

    @Override
    protected void extraChecks(ProcessingReport report, SchemaTree tree) throws ProcessingException {
        HashSet set = Sets.newHashSet((Iterator)this.getNode(tree).fieldNames());
        for (String s : Ordering.natural().sortedCopy((Iterable)set)) {
            if (RhinoHelper.regexIsValid(s)) continue;
            report.error(this.newMsg(tree, SyntaxMessages.INVALID_REGEX_MEMBER_NAME).put("memberName", s));
        }
    }
}

