/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.messages;

import com.github.fge.jsonschema.exceptions.ExceptionProvider;
import com.github.fge.jsonschema.exceptions.JsonPatchException;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.exceptions.unchecked.JsonPatchError;
import com.github.fge.jsonschema.report.MessageProvider;
import com.github.fge.jsonschema.report.ProcessingMessage;

public enum JsonPatchMessages implements MessageProvider
{
    NULL_INPUT("null inputs are not accepted"),
    NOT_JSON_PATCH("input is not a valid JSON Patch"),
    NO_SUCH_PARENT("parent of node to add does not exist"),
    NOT_AN_INDEX("reference token is not an array index"),
    NO_SUCH_INDEX("no such index in target array"),
    NO_SUCH_PATH("no such path in target JSON document"),
    VALUE_TEST_FAILURE("value differs from expectations");

    private final String message;

    private JsonPatchMessages(String message) {
        this.message = message;
    }

    @Override
    public ProcessingMessage newMessage() {
        return new ProcessingMessage().message(this).setExceptionProvider(new ExceptionProvider(){

            @Override
            public ProcessingException doException(ProcessingMessage message) {
                return new JsonPatchException(message);
            }
        });
    }

    public void checkThat(boolean condition) {
        if (!condition) {
            throw new JsonPatchError(this.newMessage());
        }
    }

    public String toString() {
        return this.message;
    }
}

