/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.jsonpointer;

import com.fasterxml.jackson.core.TreeNode;
import com.github.fge.jsonschema.exceptions.JsonReferenceException;
import com.github.fge.jsonschema.exceptions.unchecked.JsonReferenceError;
import com.github.fge.jsonschema.jsonpointer.ReferenceToken;
import com.github.fge.jsonschema.jsonpointer.TokenResolver;
import com.github.fge.jsonschema.messages.JsonReferenceErrors;
import com.github.fge.jsonschema.messages.JsonReferenceMessages;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public abstract class TreePointer<T extends TreeNode>
implements Iterable<TokenResolver<T>> {
    private static final char SLASH = '/';
    private final T missing;
    protected final List<TokenResolver<T>> tokenResolvers;

    protected TreePointer(T missing, List<TokenResolver<T>> tokenResolvers) {
        this.missing = missing;
        this.tokenResolvers = ImmutableList.copyOf(tokenResolvers);
    }

    protected TreePointer(List<TokenResolver<T>> tokenResolvers) {
        this(null, tokenResolvers);
    }

    protected static List<ReferenceToken> tokensFromInput(String input) throws JsonReferenceException {
        if (input == null) {
            throw new JsonReferenceError(new ProcessingMessage().message(JsonReferenceErrors.NULL_INPUT));
        }
        ArrayList ret = Lists.newArrayList();
        String s = input;
        while (!s.isEmpty()) {
            char c = s.charAt(0);
            if (c != '/') {
                throw new JsonReferenceException(new ProcessingMessage().message(JsonReferenceMessages.NOT_SLASH).put("expected", Character.valueOf('/')).put("found", Character.valueOf(c)));
            }
            int index = (s = s.substring(1)).indexOf(47);
            String cooked = index == -1 ? s : s.substring(0, index);
            ret.add(ReferenceToken.fromCooked(cooked));
            if (index == -1) break;
            s = s.substring(index);
        }
        return ret;
    }

    public final T get(T node) {
        T ret = node;
        for (TokenResolver<T> tokenResolver : this.tokenResolvers) {
            if (ret == null) break;
            ret = tokenResolver.get(ret);
        }
        return ret;
    }

    public final T path(T node) {
        T ret = this.get(node);
        return ret == null ? this.missing : ret;
    }

    public final boolean isEmpty() {
        return this.tokenResolvers.isEmpty();
    }

    @Override
    public final Iterator<TokenResolver<T>> iterator() {
        return this.tokenResolvers.iterator();
    }

    public final int hashCode() {
        return this.tokenResolvers.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreePointer other = (TreePointer)obj;
        return this.tokenResolvers.equals(other.tokenResolvers);
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        for (TokenResolver<T> tokenResolver : this.tokenResolvers) {
            sb.append('/').append(tokenResolver);
        }
        return sb.toString();
    }
}

