/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.JsonPatchException;
import com.github.fge.jsonschema.jsonpatch.PathValueOperation;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.messages.JsonPatchMessages;
import com.github.fge.jsonschema.util.equivalence.JsonSchemaEquivalence;
import com.google.common.base.Equivalence;

public final class TestOperation
extends PathValueOperation {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonSchemaEquivalence.getInstance();

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public TestOperation(@JsonProperty(value="path") JsonPointer path, @JsonProperty(value="value") JsonNode value) {
        super(path, value);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        JsonNode tested = this.path.path(node);
        if (tested.isMissingNode()) {
            throw new JsonPatchException(JsonPatchMessages.NO_SUCH_PATH.newMessage().put("node", node).put("path", this.path.toString()));
        }
        if (!EQUIVALENCE.equivalent((Object)tested, (Object)this.value)) {
            throw new JsonPatchException(JsonPatchMessages.VALUE_TEST_FAILURE.newMessage().put("node", node).put("path", this.path.toString()).put("expected", this.value).put("found", tested));
        }
        return node.deepCopy();
    }

    @Override
    public String toString() {
        return "test: " + super.toString();
    }
}

