/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.exceptions.JsonPatchException;
import com.github.fge.jsonschema.jsonpatch.JsonPatchOperation;
import com.github.fge.jsonschema.jsonpatch.PathValueOperation;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.messages.JsonPatchMessages;

public final class ReplaceOperation
extends PathValueOperation {
    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public ReplaceOperation(@JsonProperty(value="path") JsonPointer path, @JsonProperty(value="value") JsonNode value) {
        super(path, value);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        if (this.path.path(node).isMissingNode()) {
            throw new JsonPatchException(JsonPatchMessages.NO_SUCH_PATH.newMessage().put("node", node).put("path", this.path.toString()));
        }
        JsonNode replacement = this.value.deepCopy();
        if (this.path.isEmpty()) {
            return replacement;
        }
        JsonPatchOperation.SplitPointer split = new JsonPatchOperation.SplitPointer(this.path);
        JsonNode ret = node.deepCopy();
        JsonNode parent = split.parent.get(ret);
        String rawToken = split.lastToken.getToken().getRaw();
        if (parent.isObject()) {
            ((ObjectNode)parent).put(rawToken, replacement);
        } else {
            ((ArrayNode)parent).set(Integer.parseInt(rawToken), replacement);
        }
        return ret;
    }

    @Override
    public String toString() {
        return "replace: " + super.toString();
    }
}

