/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.JsonPatchException;
import com.github.fge.jsonschema.jsonpatch.JsonPatchOperation;
import com.github.fge.jsonschema.messages.JsonPatchMessages;
import com.github.fge.jsonschema.util.JacksonUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;

public final class JsonPatch {
    private final List<JsonPatchOperation> operations;

    @JsonCreator
    @VisibleForTesting
    JsonPatch(List<JsonPatchOperation> operations) {
        this.operations = ImmutableList.copyOf(operations);
    }

    public static JsonPatch fromJson(JsonNode node) throws JsonPatchException {
        JsonPatchMessages.NULL_INPUT.checkThat(node != null);
        try {
            return (JsonPatch)JacksonUtils.getReader().withType(JsonPatch.class).readValue(node);
        }
        catch (IOException e) {
            throw new JsonPatchException(JsonPatchMessages.NOT_JSON_PATCH.newMessage(), (Throwable)e);
        }
    }

    public JsonNode apply(JsonNode node) throws JsonPatchException {
        JsonPatchMessages.NULL_INPUT.checkThat(node != null);
        JsonNode ret = node;
        for (JsonPatchOperation operation : this.operations) {
            ret = operation.apply(ret);
        }
        return ret;
    }

    public String toString() {
        return this.operations.toString();
    }
}

