/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.JsonPatchException;
import com.github.fge.jsonschema.jsonpatch.AddOperation;
import com.github.fge.jsonschema.jsonpatch.DualPathOperation;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.messages.JsonPatchMessages;

public final class CopyOperation
extends DualPathOperation {
    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public CopyOperation(@JsonProperty(value="from") JsonPointer from, @JsonProperty(value="path") JsonPointer path) {
        super(from, path);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        JsonNode dupData = this.from.path(node).deepCopy();
        if (dupData.isMissingNode()) {
            throw new JsonPatchException(JsonPatchMessages.NO_SUCH_PATH.newMessage().put("node", node).put("path", this.from.toString()));
        }
        return new AddOperation(this.path, dupData).apply(node);
    }

    @Override
    public String toString() {
        return "copy: " + super.toString();
    }
}

